/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.security;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import org.evosuite.runtime.Random;
import org.evosuite.runtime.mock.OverrideMock;

public class MockSecureRandom
extends SecureRandom
implements OverrideMock {
    private static final long serialVersionUID = 3423648250373734907L;

    public MockSecureRandom() {
        super(new byte[]{0});
    }

    public MockSecureRandom(long seed) {
        super(MockSecureRandom.toBytes(seed));
    }

    private static byte[] toBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    @Override
    public int nextInt() {
        return Random.nextInt();
    }

    @Override
    public int nextInt(int max) {
        return Random.nextInt(max);
    }

    @Override
    public float nextFloat() {
        return Random.nextFloat();
    }

    @Override
    public void nextBytes(byte[] bytes) {
        Random.nextBytes(bytes);
    }

    @Override
    public double nextDouble() {
        return Random.nextDouble();
    }

    @Override
    public double nextGaussian() {
        return Random.nextGaussian();
    }

    @Override
    public boolean nextBoolean() {
        return Random.nextBoolean();
    }

    @Override
    public long nextLong() {
        return Random.nextLong();
    }
}

