/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.text;

import java.text.DateFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.java.util.MockCalendar;
import org.evosuite.runtime.mock.java.util.MockDate;
import org.evosuite.runtime.mock.java.util.MockTimeZone;

public class MockSimpleDateFormat
extends SimpleDateFormat
implements OverrideMock {
    public MockSimpleDateFormat() {
        this.set2DigitYearStart(new MockDate());
        this.setNumberFormat(Locale.getDefault(Locale.Category.FORMAT));
        this.initializeCalendar(Locale.getDefault(Locale.Category.FORMAT));
    }

    public MockSimpleDateFormat(String pattern) {
        this(pattern, Locale.getDefault(Locale.Category.FORMAT));
    }

    public MockSimpleDateFormat(String pattern, Locale locale) {
        super(pattern, locale);
        this.set2DigitYearStart(new MockDate());
        this.setNumberFormat(locale);
        this.initializeCalendar(locale);
    }

    public MockSimpleDateFormat(String pattern, DateFormatSymbols formatSymbols) {
        super(pattern, formatSymbols);
        this.set2DigitYearStart(new MockDate());
        this.setNumberFormat(Locale.getDefault(Locale.Category.FORMAT));
        this.initializeCalendar(Locale.getDefault(Locale.Category.FORMAT));
    }

    private void setNumberFormat(Locale locale) {
        this.numberFormat = NumberFormat.getIntegerInstance(locale);
        this.numberFormat.setGroupingUsed(false);
    }

    private void initializeCalendar(Locale loc) {
        this.calendar = MockCalendar.getInstance(MockTimeZone.getDefault(), loc);
    }
}

