/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.util.Inputs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarPathing {
    private static Logger logger = LoggerFactory.getLogger(JarPathing.class);
    private static final String PATHING_JAR_PREFIX = "EvoSuite_pathingJar";

    public static boolean containsAPathingJar(String sequence) {
        for (String token : sequence.split(File.pathSeparator)) {
            if (!JarPathing.isPathingJar(token)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPathingJar(String path) throws IllegalArgumentException {
        if (path.contains(File.pathSeparator)) {
            throw new IllegalArgumentException("Multiple elements in path: " + path);
        }
        return path != null && path.contains(PATHING_JAR_PREFIX) && path.endsWith(".jar");
    }

    public static String expandPathingJars(String sequence) {
        ArrayList<String> list = new ArrayList<String>();
        for (String token : sequence.split(File.pathSeparator)) {
            if (JarPathing.isPathingJar(token)) {
                list.add(JarPathing.extractCPFromPathingJar(token));
                continue;
            }
            list.add(token);
        }
        return String.join((CharSequence)File.pathSeparator, list);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String extractCPFromPathingJar(String pathingJar) throws IllegalArgumentException {
        Inputs.checkNull(pathingJar);
        if (!JarPathing.isPathingJar(pathingJar)) {
            throw new IllegalArgumentException("Invalid pathing jar name: " + pathingJar);
        }
        File jar = new File(pathingJar);
        if (!jar.exists()) {
            throw new IllegalArgumentException("Pathing jar does not exist: " + pathingJar);
        }
        try (JarInputStream in = new JarInputStream(new FileInputStream(jar));){
            Manifest m = in.getManifest();
            String escapedCP = m.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            ArrayList<String> list = new ArrayList<String>();
            for (String token : escapedCP.split(" ")) {
                File file = new File(token.replace("%20", " "));
                if (!file.exists()) {
                    throw new IllegalStateException("Pathing jar " + pathingJar + " refers to non-existing entry " + token);
                }
                if (JarPathing.isPathingJar(file.getAbsolutePath())) {
                    throw new IllegalArgumentException("Pathing jar " + pathingJar + " contains the pathing jar " + file.getAbsolutePath());
                }
                list.add(file.getAbsolutePath());
            }
            String string = String.join((CharSequence)File.pathSeparator, list);
            return string;
        }
        catch (IOException e) {
            logger.error(e.toString(), e);
            return pathingJar;
        }
    }

    public static String createJarPathing(String classpath) {
        logger.debug("Going to create jar pathing for: {}", (Object)classpath);
        ArrayList<String> elements = new ArrayList<String>();
        elements.addAll(Arrays.asList(classpath.split(File.pathSeparator)));
        StringBuffer escaped = new StringBuffer();
        while (!elements.isEmpty()) {
            String element = (String)elements.remove(0);
            try {
                File file = new File(element);
                element = file.getAbsolutePath();
                if (!file.exists()) {
                    logger.warn("Classpath entry does not exist: {}", (Object)element);
                    continue;
                }
                if (JarPathing.isPathingJar(element)) {
                    elements.addAll(Arrays.asList(JarPathing.extractCPFromPathingJar(element).split(File.pathSeparator)));
                    continue;
                }
                element = element.replace("\\", "/");
                if (!(element = element.replace(" ", "%20")).startsWith("/")) {
                    element = "/" + element;
                }
                if (!element.endsWith(".jar") && !element.endsWith("/")) {
                    element = element + "/";
                }
                escaped.append(element + " ");
            }
            catch (Exception e) {
                logger.error("Problem when encoding '" + element + "': " + e.toString());
                return classpath;
            }
        }
        String jarLocation = null;
        try {
            File tmp = File.createTempFile(PATHING_JAR_PREFIX, ".jar");
            tmp.deleteOnExit();
            jarLocation = tmp.getAbsolutePath();
            Manifest m = new Manifest();
            m.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            m.getMainAttributes().put(Attributes.Name.CLASS_PATH, escaped.toString());
            JarOutputStream out = new JarOutputStream((OutputStream)new FileOutputStream(tmp), m);
            out.flush();
            out.close();
            if (!RuntimeSettings.isRunningASystemTest) {
                logger.info("Created jar path at {} with CP: {}", (Object)jarLocation, (Object)escaped.toString());
            }
        }
        catch (Exception e) {
            logger.error("Cannot create pathing jar: " + e.toString());
            return classpath;
        }
        return jarLocation;
    }
}

