/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.vfs;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.runtime.vfs.FSObject;
import org.evosuite.runtime.vfs.VFolder;

public class VFile
extends FSObject {
    private final List<Byte> data = new ArrayList<Byte>(1024);

    public VFile(String path, VFolder parent) {
        super(path, parent);
    }

    public void eraseData() {
        this.data.clear();
    }

    public synchronized int getDataSize() {
        return this.data.size();
    }

    public synchronized void setLength(int newLength) {
        while (newLength > this.data.size()) {
            this.data.add((byte)0);
        }
        if (newLength == 0) {
            this.data.clear();
            return;
        }
        while (this.data.size() > newLength) {
            this.data.remove(this.data.size() - 1);
        }
    }

    public synchronized int read(int position) throws IllegalArgumentException {
        if (position < 0) {
            throw new IllegalArgumentException("Position in the file cannot be negative");
        }
        if (position >= this.data.size()) {
            return -1;
        }
        return this.data.get(position) & 0xFF;
    }

    public synchronized int writeBytes(byte[] b, int off, int len) {
        return this.writeBytes(this.data.size(), b, off, len);
    }

    public synchronized int writeBytes(int position, byte[] b, int off, int len) throws IllegalArgumentException {
        if (position < 0) {
            throw new IllegalArgumentException("Position in the file cannot be negative");
        }
        if (this.deleted || !this.isWritePermission()) {
            return 0;
        }
        if (position >= this.data.size()) {
            this.setLength(position);
        }
        int written = 0;
        int i = off;
        while (i < b.length & i - off < len) {
            if (position < this.data.size()) {
                this.data.set(position, b[i]);
            } else {
                this.data.add(b[i]);
            }
            ++position;
            ++written;
            ++i;
        }
        this.setLastModified(this.getCurrentTimeMillis());
        return written;
    }

    @Override
    public synchronized boolean delete() {
        this.eraseData();
        return super.delete();
    }
}

