/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.evosuite.PackageInfo;
import org.evosuite.Properties;
import org.evosuite.setup.Call;
import org.evosuite.testcase.execution.MethodCall;

public class CallContext
implements Serializable {
    private static final long serialVersionUID = 8650619230188403356L;
    private final List<Call> context;
    private final int hcode;
    private String[] excludedPackages = new String[]{"java", "sun", PackageInfo.getEvoSuitePackage()};

    public boolean isEmpty() {
        return this.context.isEmpty();
    }

    public CallContext(StackTraceElement[] stackTrace) {
        this.addJUnitExcludes();
        int endPos = 0;
        ArrayList<Call> context = new ArrayList<Call>();
        for (int startPos = stackTrace.length - 1; startPos >= 0 && this.shouldSkipEntry(stackTrace[startPos].getClassName()); --startPos) {
        }
        while (endPos < stackTrace.length && this.shouldSkipEntry(stackTrace[endPos].getClassName())) {
            ++endPos;
        }
        for (int i = startPos; i >= endPos; --i) {
            StackTraceElement element = stackTrace[i];
            Call newCall = new Call(element.getClassName(), element.getMethodName());
            boolean skip = false;
            if (context.size() >= 2) {
                Call previousCall1 = (Call)context.get(context.size() - 1);
                Call previousCall2 = (Call)context.get(context.size() - 2);
                if (previousCall1.equals(newCall) && previousCall2.equals(newCall)) {
                    skip = true;
                }
            }
            if (skip) continue;
            context.add(newCall);
        }
        this.context = context;
        this.hcode = this.context.hashCode();
    }

    public CallContext(LinkedList<MethodCall> stackTrace) {
        this.addJUnitExcludes();
        int endPos = 0;
        ArrayList<Call> context = new ArrayList<Call>();
        for (int startPos = stackTrace.size() - 1; startPos >= 0 && this.shouldSkipEntry(stackTrace.get((int)startPos).className); --startPos) {
        }
        while (endPos < stackTrace.size() && this.shouldSkipEntry(stackTrace.get((int)endPos).className)) {
            ++endPos;
        }
        for (int i = startPos; i >= endPos; --i) {
            MethodCall element = stackTrace.get(i);
            Call newCall = new Call(element.className, element.methodName);
            boolean skip = false;
            if (context.size() >= 2) {
                Call previousCall1 = (Call)context.get(context.size() - 1);
                Call previousCall2 = (Call)context.get(context.size() - 2);
                if (previousCall1.equals(newCall) && previousCall2.equals(newCall)) {
                    skip = true;
                }
            }
            if (skip) continue;
            context.add(newCall);
        }
        this.context = context;
        this.hcode = this.context.hashCode();
    }

    public CallContext(String className, String methodName) {
        this.addJUnitExcludes();
        ArrayList<Call> context = new ArrayList<Call>();
        context.add(new Call(className, methodName));
        this.context = context;
        this.hcode = this.context.hashCode();
    }

    public CallContext() {
        this.addJUnitExcludes();
        ArrayList<Call> context = new ArrayList<Call>();
        this.context = context;
        this.hcode = this.context.hashCode();
    }

    public CallContext(Collection<Call> contextt) {
        this.addJUnitExcludes();
        ArrayList<Call> context = new ArrayList<Call>();
        context.addAll(contextt);
        this.context = context;
        this.hcode = this.context.hashCode();
    }

    public int size() {
        return this.context.size();
    }

    private void addJUnitExcludes() {
        if (Properties.JUNIT.isEmpty()) {
            return;
        }
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(this.excludedPackages));
        values.add("org.junit");
        for (String junitClass : Properties.JUNIT.split(":")) {
            values.add(junitClass);
        }
        this.excludedPackages = new String[values.size()];
        this.excludedPackages = values.toArray(this.excludedPackages);
    }

    private boolean shouldSkipEntry(String entry) {
        if (entry.isEmpty()) {
            return true;
        }
        for (String excludedPackage : this.excludedPackages) {
            if (!entry.startsWith(excludedPackage)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public CallContext getSuperContext(String className, String methodName) {
        throw new IllegalStateException("YET TO IMPLEMENT, DEPRECATED");
    }

    public String getRootClassName() {
        return this.context.get(0).getClassName();
    }

    public String getRootMethodName() {
        return this.context.get(0).getMethodName();
    }

    public String toString() {
        if (this.context == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Call call : this.context) {
            builder.append(call.toString());
            builder.append(" ");
        }
        String tmp = builder.toString();
        return tmp.trim();
    }

    public int hashCode() {
        return this.hcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallContext other = (CallContext)obj;
        return this.hcode == other.hcode;
    }

    public boolean oldMatches(CallContext other) {
        if (this.context.size() != other.context.size()) {
            return false;
        }
        if (other.hcode == this.hcode) {
            return true;
        }
        for (int i = 0; i < this.context.size(); ++i) {
            Call call2;
            Call call1 = this.context.get(i);
            if (call1.matches(call2 = other.context.get(i))) continue;
            return false;
        }
        return false;
    }

    public boolean matches(CallContext other) {
        return this.context.isEmpty() || other.context.isEmpty() || other.hcode == this.hcode;
    }

    public List<Call> getContext() {
        return this.context;
    }
}

