/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.evosuite.classpath.ResourceList;
import org.evosuite.utils.LoggingUtils;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.graph.EdgeReversedGraph;
import org.jgrapht.traverse.BreadthFirstIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InheritanceTree {
    private static Logger logger = LoggerFactory.getLogger(InheritanceTree.class);
    private final Map<String, Set<String>> subclassCache = new LinkedHashMap<String, Set<String>>();
    private Set<String> interfacesSet = new LinkedHashSet<String>();
    private Set<String> abstractClassesSet = new LinkedHashSet<String>();
    private Map<String, Set<String>> analyzedMethods;
    private DirectedMultigraph<String, DefaultEdge> inheritanceGraph = new DirectedMultigraph(DefaultEdge.class);

    private void initialiseMap() {
        if (this.analyzedMethods == null) {
            this.analyzedMethods = new LinkedHashMap<String, Set<String>>();
        }
        if (this.interfacesSet == null) {
            this.interfacesSet = new LinkedHashSet<String>();
        }
        if (this.abstractClassesSet == null) {
            this.abstractClassesSet = new LinkedHashSet<String>();
        }
    }

    public boolean isClassDefined(String className) {
        this.initialiseMap();
        return this.analyzedMethods.containsKey(className);
    }

    public boolean isInterface(String classname) {
        return this.interfacesSet.contains(classname);
    }

    public boolean isAbstractClass(String classname) {
        return this.abstractClassesSet.contains(classname);
    }

    public void registerAbstractClass(String abstractClassName) {
        this.initialiseMap();
        this.abstractClassesSet.add(ResourceList.getClassNameFromResourcePath(abstractClassName));
    }

    public void registerInterface(String interfaceName) {
        this.initialiseMap();
        this.interfacesSet.add(ResourceList.getClassNameFromResourcePath(interfaceName));
    }

    public boolean isMethodDefined(String className, String methodNameWdescriptor) {
        this.initialiseMap();
        if (this.analyzedMethods.get(className) == null) {
            return false;
        }
        return this.analyzedMethods.get(className).contains(methodNameWdescriptor);
    }

    public boolean isMethodDefined(String className, String methodName, String descriptor) {
        this.initialiseMap();
        if (this.analyzedMethods.get(className) == null) {
            return false;
        }
        return this.analyzedMethods.get(className).contains(methodName + descriptor);
    }

    public void addAnalyzedMethod(String classname, String methodname, String descriptor) {
        this.initialiseMap();
        classname = classname.replace(File.separator, ".");
        Set<String> tmp = this.analyzedMethods.get(classname);
        if (tmp == null) {
            tmp = new LinkedHashSet<String>();
            this.analyzedMethods.put(classname, tmp);
        }
        tmp.add(methodname + descriptor);
    }

    public void addSuperclass(String className, String superName, int access) {
        String classNameWithDots = ResourceList.getClassNameFromResourcePath(className);
        String superNameWithDots = ResourceList.getClassNameFromResourcePath(superName);
        if (this.inheritanceGraph == null) {
            this.inheritanceGraph = new DirectedMultigraph(DefaultEdge.class);
        }
        this.inheritanceGraph.addVertex(classNameWithDots);
        this.inheritanceGraph.addVertex(superNameWithDots);
        this.inheritanceGraph.addEdge(superNameWithDots, classNameWithDots);
    }

    public void addInterface(String className, String interfaceName) {
        String classNameWithDots = ResourceList.getClassNameFromResourcePath(className);
        String interfaceNameWithDots = ResourceList.getClassNameFromResourcePath(interfaceName);
        this.inheritanceGraph.addVertex(classNameWithDots);
        this.inheritanceGraph.addVertex(interfaceNameWithDots);
        this.inheritanceGraph.addEdge(interfaceNameWithDots, classNameWithDots);
        this.interfacesSet.add(interfaceNameWithDots);
    }

    public Set<String> getSubclasses(String className) {
        String classNameWithDots = ResourceList.getClassNameFromResourcePath(className);
        if (this.subclassCache.containsKey(classNameWithDots)) {
            return this.subclassCache.get(classNameWithDots);
        }
        if (!this.inheritanceGraph.containsVertex(classNameWithDots)) {
            LoggingUtils.logWarnAtMostOnce(logger, "Class not in inheritance graph: " + classNameWithDots);
            return new LinkedHashSet<String>();
        }
        TreeSet<String> result = new TreeSet<String>();
        BreadthFirstIterator<String, DefaultEdge> bfi = new BreadthFirstIterator<String, DefaultEdge>(this.inheritanceGraph, classNameWithDots);
        while (bfi.hasNext()) {
            result.add((String)bfi.next());
        }
        this.subclassCache.put(classNameWithDots, result);
        return result;
    }

    public Set<String> getSuperclasses(String className) {
        String classNameWithDots = ResourceList.getClassNameFromResourcePath(className);
        if (!this.inheritanceGraph.containsVertex(classNameWithDots)) {
            LoggingUtils.logWarnAtMostOnce(logger, "Class not in inheritance graph: " + classNameWithDots);
            return new LinkedHashSet<String>();
        }
        EdgeReversedGraph<String, DefaultEdge> reverseGraph = new EdgeReversedGraph<String, DefaultEdge>((DirectedGraph<String, DefaultEdge>)this.inheritanceGraph);
        TreeSet<String> result = new TreeSet<String>();
        BreadthFirstIterator<String, DefaultEdge> bfi = new BreadthFirstIterator<String, DefaultEdge>(reverseGraph, classNameWithDots);
        while (bfi.hasNext()) {
            result.add((String)bfi.next());
        }
        return result;
    }

    public List<String> getOrderedSuperclasses(String className) {
        String classNameWithDots = ResourceList.getClassNameFromResourcePath(className);
        if (!this.inheritanceGraph.containsVertex(classNameWithDots)) {
            LoggingUtils.logWarnAtMostOnce(logger, "Class not in inheritance graph: " + classNameWithDots);
            return new LinkedList<String>();
        }
        EdgeReversedGraph<String, DefaultEdge> reverseGraph = new EdgeReversedGraph<String, DefaultEdge>((DirectedGraph<String, DefaultEdge>)this.inheritanceGraph);
        LinkedList<String> orderedList = new LinkedList<String>();
        BreadthFirstIterator<String, DefaultEdge> bfi = new BreadthFirstIterator<String, DefaultEdge>(reverseGraph, classNameWithDots);
        while (bfi.hasNext()) {
            orderedList.add((String)bfi.next());
        }
        return orderedList;
    }

    public Set<String> getAllClasses() {
        return this.inheritanceGraph.vertexSet();
    }

    public void removeClass(String className) {
        this.inheritanceGraph.removeVertex(className);
    }

    public boolean hasClass(String className) {
        return this.inheritanceGraph.containsVertex(className);
    }

    public int getNumClasses() {
        return this.inheritanceGraph.vertexSet().size();
    }
}

