/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.event.internal;

import java.util.IdentityHashMap;
import java.util.Map;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.ObjectDeletedException;
import org.evosuite.shaded.org.hibernate.PersistentObjectException;
import org.evosuite.shaded.org.hibernate.engine.spi.CascadingAction;
import org.evosuite.shaded.org.hibernate.engine.spi.CascadingActions;
import org.evosuite.shaded.org.hibernate.engine.spi.EntityEntry;
import org.evosuite.shaded.org.hibernate.engine.spi.Status;
import org.evosuite.shaded.org.hibernate.event.internal.AbstractSaveEventListener;
import org.evosuite.shaded.org.hibernate.event.spi.EventSource;
import org.evosuite.shaded.org.hibernate.event.spi.PersistEvent;
import org.evosuite.shaded.org.hibernate.event.spi.PersistEventListener;
import org.evosuite.shaded.org.hibernate.id.ForeignGenerator;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.persister.entity.EntityPersister;
import org.evosuite.shaded.org.hibernate.pretty.MessageHelper;
import org.evosuite.shaded.org.hibernate.proxy.HibernateProxy;
import org.evosuite.shaded.org.hibernate.proxy.LazyInitializer;

public class DefaultPersistEventListener
extends AbstractSaveEventListener
implements PersistEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultPersistEventListener.class);

    @Override
    protected CascadingAction getCascadeAction() {
        return CascadingActions.PERSIST;
    }

    @Override
    protected Boolean getAssumedUnsaved() {
        return Boolean.TRUE;
    }

    @Override
    public void onPersist(PersistEvent event) throws HibernateException {
        this.onPersist(event, new IdentityHashMap(10));
    }

    @Override
    public void onPersist(PersistEvent event, Map createCache) throws HibernateException {
        EntityPersister persister;
        String entityName;
        Object entity;
        EventSource source = event.getSession();
        Object object = event.getObject();
        if (object instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                if (li.getSession() == source) {
                    return;
                }
                throw new PersistentObjectException("uninitialized proxy passed to persist()");
            }
            entity = li.getImplementation();
        } else {
            entity = object;
        }
        if (event.getEntityName() != null) {
            entityName = event.getEntityName();
        } else {
            entityName = source.bestGuessEntityName(entity);
            event.setEntityName(entityName);
        }
        EntityEntry entityEntry = source.getPersistenceContext().getEntry(entity);
        AbstractSaveEventListener.EntityState entityState = this.getEntityState(entity, entityName, entityEntry, source);
        if (entityState == AbstractSaveEventListener.EntityState.DETACHED && ForeignGenerator.class.isInstance((persister = source.getFactory().getEntityPersister(entityName)).getIdentifierGenerator())) {
            if (LOG.isDebugEnabled() && persister.getIdentifier(entity, source) != null) {
                LOG.debug("Resetting entity id attribute to null for foreign generator");
            }
            persister.setIdentifier(entity, null, source);
            entityState = this.getEntityState(entity, entityName, entityEntry, source);
        }
        switch (entityState) {
            case DETACHED: {
                throw new PersistentObjectException("detached entity passed to persist: " + this.getLoggableName(event.getEntityName(), entity));
            }
            case PERSISTENT: {
                this.entityIsPersistent(event, createCache);
                break;
            }
            case TRANSIENT: {
                this.entityIsTransient(event, createCache);
                break;
            }
            case DELETED: {
                entityEntry.setStatus(Status.MANAGED);
                entityEntry.setDeletedState(null);
                event.getSession().getActionQueue().unScheduleDeletion(entityEntry, event.getObject());
                this.entityIsDeleted(event, createCache);
                break;
            }
            default: {
                throw new ObjectDeletedException("deleted entity passed to persist", null, this.getLoggableName(event.getEntityName(), entity));
            }
        }
    }

    protected void entityIsPersistent(PersistEvent event, Map createCache) {
        LOG.trace("Ignoring persistent instance");
        EventSource source = event.getSession();
        Object entity = source.getPersistenceContext().unproxy(event.getObject());
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        if (createCache.put(entity, entity) == null) {
            this.justCascade(createCache, source, entity, persister);
        }
    }

    private void justCascade(Map createCache, EventSource source, Object entity, EntityPersister persister) {
        this.cascadeBeforeSave(source, persister, entity, createCache);
        this.cascadeAfterSave(source, persister, entity, createCache);
    }

    protected void entityIsTransient(PersistEvent event, Map createCache) {
        LOG.trace("Saving transient instance");
        EventSource source = event.getSession();
        Object entity = source.getPersistenceContext().unproxy(event.getObject());
        if (createCache.put(entity, entity) == null) {
            this.saveWithGeneratedId(entity, event.getEntityName(), createCache, source, false);
        }
    }

    private void entityIsDeleted(PersistEvent event, Map createCache) {
        EventSource source = event.getSession();
        Object entity = source.getPersistenceContext().unproxy(event.getObject());
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        LOG.tracef("un-scheduling entity deletion [%s]", (Object)MessageHelper.infoString(persister, persister.getIdentifier(entity, source), source.getFactory()));
        if (createCache.put(entity, entity) == null) {
            this.justCascade(createCache, source, entity, persister);
        }
    }
}

