/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.event.service.internal;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultAutoFlushEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultDeleteEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultDirtyCheckEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultEvictEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultFlushEntityEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultFlushEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultInitializeCollectionEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultLoadEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultLockEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultMergeEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultPersistEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultPersistOnFlushEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultPostLoadEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultPreLoadEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultRefreshEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultReplicateEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultResolveNaturalIdEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultSaveEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultSaveOrUpdateEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultUpdateEventListener;
import org.evosuite.shaded.org.hibernate.event.service.internal.EventListenerGroupImpl;
import org.evosuite.shaded.org.hibernate.event.service.internal.PostCommitEventListenerGroupImpl;
import org.evosuite.shaded.org.hibernate.event.service.spi.DuplicationStrategy;
import org.evosuite.shaded.org.hibernate.event.service.spi.EventListenerGroup;
import org.evosuite.shaded.org.hibernate.event.service.spi.EventListenerRegistrationException;
import org.evosuite.shaded.org.hibernate.event.service.spi.EventListenerRegistry;
import org.evosuite.shaded.org.hibernate.event.spi.EventType;

public class EventListenerRegistryImpl
implements EventListenerRegistry {
    private Map<Class, Object> listenerClassToInstanceMap = new HashMap<Class, Object>();
    private EventListenerGroupImpl[] registeredEventListeners = EventListenerRegistryImpl.prepareListenerAssociation();

    public <T> EventListenerGroupImpl<T> getEventListenerGroup(EventType<T> eventType) {
        EventListenerGroupImpl listeners = this.registeredEventListeners[eventType.ordinal()];
        if (listeners == null) {
            throw new HibernateException("Unable to find listeners for type [" + eventType.eventName() + "]");
        }
        return listeners;
    }

    @Override
    public void addDuplicationStrategy(DuplicationStrategy strategy) {
        for (EventListenerGroupImpl group : this.registeredEventListeners) {
            if (group == null) continue;
            group.addDuplicationStrategy(strategy);
        }
    }

    @Override
    public <T> void setListeners(EventType<T> type, Class<? extends T> ... listenerClasses) {
        this.setListeners(type, this.resolveListenerInstances(type, listenerClasses));
    }

    private <T> T[] resolveListenerInstances(EventType<T> type, Class<? extends T> ... listenerClasses) {
        Object[] listeners = (Object[])Array.newInstance(type.baseListenerInterface(), listenerClasses.length);
        for (int i = 0; i < listenerClasses.length; ++i) {
            listeners[i] = this.resolveListenerInstance(listenerClasses[i]);
        }
        return listeners;
    }

    private <T> T resolveListenerInstance(Class<T> listenerClass) {
        Object listenerInstance = this.listenerClassToInstanceMap.get(listenerClass);
        if (listenerInstance == null) {
            listenerInstance = this.instantiateListener(listenerClass);
            this.listenerClassToInstanceMap.put(listenerClass, listenerInstance);
        }
        return (T)listenerInstance;
    }

    private <T> T instantiateListener(Class<T> listenerClass) {
        try {
            return listenerClass.newInstance();
        }
        catch (Exception e) {
            throw new EventListenerRegistrationException("Unable to instantiate specified event listener class: " + listenerClass.getName(), e);
        }
    }

    @Override
    public <T> void setListeners(EventType<T> type, T ... listeners) {
        EventListenerGroup registeredListeners = this.getEventListenerGroup((EventType)type);
        ((EventListenerGroupImpl)registeredListeners).clear();
        if (listeners != null) {
            int max = listeners.length;
            for (int i = 0; i < max; ++i) {
                ((EventListenerGroupImpl)registeredListeners).appendListener(listeners[i]);
            }
        }
    }

    @Override
    public <T> void appendListeners(EventType<T> type, Class<? extends T> ... listenerClasses) {
        this.appendListeners(type, this.resolveListenerInstances(type, listenerClasses));
    }

    @Override
    public <T> void appendListeners(EventType<T> type, T ... listeners) {
        ((EventListenerGroupImpl)this.getEventListenerGroup((EventType)type)).appendListeners(listeners);
    }

    @Override
    public <T> void prependListeners(EventType<T> type, Class<? extends T> ... listenerClasses) {
        this.prependListeners(type, this.resolveListenerInstances(type, listenerClasses));
    }

    @Override
    public <T> void prependListeners(EventType<T> type, T ... listeners) {
        ((EventListenerGroupImpl)this.getEventListenerGroup((EventType)type)).prependListeners(listeners);
    }

    private static EventListenerGroupImpl[] prepareListenerAssociation() {
        EventListenerGroupImpl[] listenerArray = new EventListenerGroupImpl[EventType.values().size()];
        EventListenerRegistryImpl.prepareListeners(EventType.AUTO_FLUSH, new DefaultAutoFlushEventListener(), listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.PERSIST, new DefaultPersistEventListener(), listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.PERSIST_ONFLUSH, new DefaultPersistOnFlushEventListener(), listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.DELETE, new DefaultDeleteEventListener(), listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.DIRTY_CHECK, new DefaultDirtyCheckEventListener(), listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.EVICT, new DefaultEvictEventListener(), listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.CLEAR, listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.FLUSH, new DefaultFlushEventListener(), listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.FLUSH_ENTITY, new DefaultFlushEntityEventListener(), listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.LOAD, new DefaultLoadEventListener(), listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.RESOLVE_NATURAL_ID, new DefaultResolveNaturalIdEventListener(), listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.INIT_COLLECTION, new DefaultInitializeCollectionEventListener(), listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.LOCK, new DefaultLockEventListener(), listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.MERGE, new DefaultMergeEventListener(), listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_COLLECTION_RECREATE, listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_COLLECTION_REMOVE, listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_COLLECTION_UPDATE, listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_DELETE, listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_INSERT, listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_LOAD, new DefaultPreLoadEventListener(), listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_UPDATE, listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_COLLECTION_RECREATE, listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_COLLECTION_REMOVE, listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_COLLECTION_UPDATE, listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_COMMIT_DELETE, listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_COMMIT_INSERT, listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_COMMIT_UPDATE, listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_DELETE, listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_INSERT, listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_LOAD, new DefaultPostLoadEventListener(), listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_UPDATE, listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.UPDATE, new DefaultUpdateEventListener(), listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.REFRESH, new DefaultRefreshEventListener(), listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.REPLICATE, new DefaultReplicateEventListener(), listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.SAVE, new DefaultSaveEventListener(), listenerArray);
        EventListenerRegistryImpl.prepareListeners(EventType.SAVE_UPDATE, new DefaultSaveOrUpdateEventListener(), listenerArray);
        return listenerArray;
    }

    private static <T> void prepareListeners(EventType<T> type, EventListenerGroupImpl[] listenerArray) {
        EventListenerRegistryImpl.prepareListeners(type, null, listenerArray);
    }

    private static <T> void prepareListeners(EventType<T> type, T defaultListener, EventListenerGroupImpl[] listenerArray) {
        EventListenerGroupImpl listenerGroup = type == EventType.POST_COMMIT_DELETE || type == EventType.POST_COMMIT_INSERT || type == EventType.POST_COMMIT_UPDATE ? new PostCommitEventListenerGroupImpl<T>(type) : new EventListenerGroupImpl<T>(type);
        if (defaultListener != null) {
            ((EventListenerGroupImpl)listenerGroup).appendListener(defaultListener);
        }
        listenerArray[type.ordinal()] = listenerGroup;
    }
}

