/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.jpa.event.internal.jpa;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.evosuite.shaded.org.hibernate.jpa.event.spi.jpa.Listener;
import org.evosuite.shaded.org.hibernate.jpa.event.spi.jpa.ListenerFactory;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class ListenerFactoryBeanManagerDelayedImpl
implements ListenerFactory {
    private static final Logger log = Logger.getLogger(ListenerFactoryBeanManagerDelayedImpl.class);
    private final BeanManager beanManager;
    private final Map<Class, ListenerImpl> listenerMap = new ConcurrentHashMap<Class, ListenerImpl>();

    public static ListenerFactoryBeanManagerDelayedImpl fromBeanManagerReference(Object reference) {
        if (!BeanManager.class.isInstance(reference)) {
            throw new IllegalArgumentException("Expecting BeanManager reference that implements CDI BeanManager contract : " + reference);
        }
        return new ListenerFactoryBeanManagerDelayedImpl((BeanManager)reference);
    }

    public ListenerFactoryBeanManagerDelayedImpl(BeanManager beanManager) {
        this.beanManager = beanManager;
        log.debugf("Delayed access requested to CDI BeanManager : " + beanManager, new Object[0]);
    }

    @Override
    public <T> Listener<T> buildListener(Class<T> listenerClass) {
        ListenerImpl listenerImpl = this.listenerMap.get(listenerClass);
        if (listenerImpl == null) {
            listenerImpl = new ListenerImpl(listenerClass);
            this.listenerMap.put(listenerClass, listenerImpl);
        }
        return listenerImpl;
    }

    @Override
    public void release() {
        for (ListenerImpl listenerImpl : this.listenerMap.values()) {
            listenerImpl.release();
        }
        this.listenerMap.clear();
    }

    private class ListenerImpl<T>
    implements Listener<T> {
        private final Class<T> listenerClass;
        private boolean initialized = false;
        private InjectionTarget<T> injectionTarget;
        private CreationalContext<T> creationalContext;
        private T listenerInstance;

        private ListenerImpl(Class<T> listenerClass) {
            this.listenerClass = listenerClass;
            log.debugf("Delayed CDI listener built : " + listenerClass, new Object[0]);
        }

        public void initialize() {
            log.debug("Initializing delayed CDI listener on first use : " + this.listenerClass);
            AnnotatedType<T> annotatedType = ListenerFactoryBeanManagerDelayedImpl.this.beanManager.createAnnotatedType(this.listenerClass);
            this.injectionTarget = ListenerFactoryBeanManagerDelayedImpl.this.beanManager.createInjectionTarget(annotatedType);
            this.creationalContext = ListenerFactoryBeanManagerDelayedImpl.this.beanManager.createCreationalContext(null);
            this.listenerInstance = this.injectionTarget.produce(this.creationalContext);
            this.injectionTarget.inject(this.listenerInstance, this.creationalContext);
            this.injectionTarget.postConstruct(this.listenerInstance);
            this.initialized = true;
        }

        @Override
        public T getListener() {
            if (!this.initialized) {
                this.initialize();
            }
            return this.listenerInstance;
        }

        public void release() {
            if (!this.initialized) {
                log.debug("Skipping release for CDI listener [" + this.listenerClass + "] as it was not initialized");
                return;
            }
            log.debug("Releasing CDI listener : " + this.listenerClass);
            this.injectionTarget.preDestroy(this.listenerInstance);
            this.injectionTarget.dispose(this.listenerInstance);
            this.creationalContext.release();
        }
    }
}

