/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.loader.entity;

import java.io.Serializable;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.LockMode;
import org.evosuite.shaded.org.hibernate.LockOptions;
import org.evosuite.shaded.org.hibernate.engine.internal.BatchFetchQueueHelper;
import org.evosuite.shaded.org.hibernate.engine.spi.LoadQueryInfluencers;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.evosuite.shaded.org.hibernate.internal.util.collections.ArrayHelper;
import org.evosuite.shaded.org.hibernate.loader.Loader;
import org.evosuite.shaded.org.hibernate.loader.entity.BatchingEntityLoader;
import org.evosuite.shaded.org.hibernate.loader.entity.BatchingEntityLoaderBuilder;
import org.evosuite.shaded.org.hibernate.loader.entity.EntityLoader;
import org.evosuite.shaded.org.hibernate.loader.entity.UniqueEntityLoader;
import org.evosuite.shaded.org.hibernate.persister.entity.OuterJoinLoadable;

class PaddedBatchingEntityLoaderBuilder
extends BatchingEntityLoaderBuilder {
    public static final PaddedBatchingEntityLoaderBuilder INSTANCE = new PaddedBatchingEntityLoaderBuilder();

    PaddedBatchingEntityLoaderBuilder() {
    }

    @Override
    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable persister, int batchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        return new PaddedBatchingEntityLoader(persister, batchSize, lockMode, factory, influencers);
    }

    @Override
    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable persister, int batchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        return new PaddedBatchingEntityLoader(persister, batchSize, lockOptions, factory, influencers);
    }

    public static class PaddedBatchingEntityLoader
    extends BatchingEntityLoader {
        private final int[] batchSizes;
        private final Loader[] loaders;

        public PaddedBatchingEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
            super(persister);
            this.batchSizes = ArrayHelper.getBatchSizes(maxBatchSize);
            this.loaders = new Loader[this.batchSizes.length];
            for (int i = 0; i < this.batchSizes.length; ++i) {
                this.loaders[i] = new EntityLoader(persister, this.batchSizes[i], lockMode, factory, loadQueryInfluencers);
            }
            this.validate(maxBatchSize);
        }

        private void validate(int max) {
            if (this.batchSizes[0] != max) {
                throw new HibernateException("Unexpected batch size spread");
            }
            if (this.batchSizes[this.batchSizes.length - 1] != 1) {
                throw new HibernateException("Unexpected batch size spread");
            }
        }

        public PaddedBatchingEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
            super(persister);
            this.batchSizes = ArrayHelper.getBatchSizes(maxBatchSize);
            this.loaders = new Loader[this.batchSizes.length];
            for (int i = 0; i < this.batchSizes.length; ++i) {
                this.loaders[i] = new EntityLoader(persister, this.batchSizes[i], lockOptions, factory, loadQueryInfluencers);
            }
            this.validate(maxBatchSize);
        }

        @Override
        public Object load(Serializable id, Object optionalObject, SharedSessionContractImplementor session, LockOptions lockOptions) {
            Serializable[] batch = session.getPersistenceContext().getBatchFetchQueue().getEntityBatch(this.persister(), id, this.batchSizes[0], this.persister().getEntityMode());
            int numberOfIds = ArrayHelper.countNonNull(batch);
            if (numberOfIds <= 1) {
                Object result = ((UniqueEntityLoader)((Object)this.loaders[this.batchSizes.length - 1])).load(id, optionalObject, session);
                if (result == null) {
                    BatchFetchQueueHelper.removeBatchLoadableEntityKey(id, this.persister(), session);
                }
                return result;
            }
            int indexToUse = this.batchSizes.length - 1;
            int i = 0;
            while (i < this.batchSizes.length - 1 && this.batchSizes[i] >= numberOfIds) {
                indexToUse = i++;
            }
            Serializable[] idsToLoad = new Serializable[this.batchSizes[indexToUse]];
            System.arraycopy(batch, 0, idsToLoad, 0, numberOfIds);
            for (int i2 = numberOfIds; i2 < this.batchSizes[indexToUse]; ++i2) {
                idsToLoad[i2] = id;
            }
            return this.doBatchLoad(id, this.loaders[indexToUse], session, idsToLoad, optionalObject, lockOptions);
        }
    }
}

