/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.loader.plan.build.internal;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeNode;
import javax.persistence.Subgraph;
import javax.persistence.metamodel.Attribute;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.LockMode;
import org.evosuite.shaded.org.hibernate.engine.FetchStrategy;
import org.evosuite.shaded.org.hibernate.engine.FetchStyle;
import org.evosuite.shaded.org.hibernate.engine.FetchTiming;
import org.evosuite.shaded.org.hibernate.engine.spi.LoadQueryInfluencers;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.graph.spi.AttributeNodeImplementor;
import org.evosuite.shaded.org.hibernate.graph.spi.GraphNodeImplementor;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.loader.plan.build.internal.AbstractLoadPlanBuildingAssociationVisitationStrategy;
import org.evosuite.shaded.org.hibernate.loader.plan.build.internal.LoadPlanImpl;
import org.evosuite.shaded.org.hibernate.loader.plan.spi.EntityReturn;
import org.evosuite.shaded.org.hibernate.loader.plan.spi.LoadPlan;
import org.evosuite.shaded.org.hibernate.loader.plan.spi.QuerySpaces;
import org.evosuite.shaded.org.hibernate.loader.plan.spi.Return;
import org.evosuite.shaded.org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.evosuite.shaded.org.hibernate.persister.walking.spi.AttributeDefinition;
import org.evosuite.shaded.org.hibernate.persister.walking.spi.CollectionElementDefinition;
import org.evosuite.shaded.org.hibernate.persister.walking.spi.CollectionIndexDefinition;
import org.evosuite.shaded.org.hibernate.persister.walking.spi.EntityDefinition;
import org.evosuite.shaded.org.hibernate.persister.walking.spi.WalkingException;
import org.evosuite.shaded.org.jboss.logging.Logger;

public abstract class AbstractEntityGraphVisitationStrategy
extends AbstractLoadPlanBuildingAssociationVisitationStrategy {
    private static final Logger LOG = CoreLogging.logger(AbstractEntityGraphVisitationStrategy.class);
    protected static final FetchStrategy DEFAULT_EAGER = new FetchStrategy(FetchTiming.IMMEDIATE, FetchStyle.JOIN);
    protected static final FetchStrategy DEFAULT_LAZY = new FetchStrategy(FetchTiming.DELAYED, FetchStyle.SELECT);
    protected final LoadQueryInfluencers loadQueryInfluencers;
    private final ArrayDeque<GraphNodeImplementor> graphStack = new ArrayDeque();
    private final ArrayDeque<AttributeNodeImplementor> attributeStack = new ArrayDeque();
    private final ArrayDeque<Map<String, AttributeNodeImplementor>> attributeMapStack = new ArrayDeque();
    private EntityReturn rootEntityReturn;
    private final LockMode lockMode;
    private static final AttributeNodeImplementor NON_EXIST_ATTRIBUTE_NODE = new AttributeNodeImplementor(){

        public Attribute getAttribute() {
            return null;
        }

        public AttributeNodeImplementor makeImmutableCopy() {
            return this;
        }

        @Override
        public String getAttributeName() {
            return null;
        }

        @Override
        public Map<Class, Subgraph> getSubgraphs() {
            return Collections.emptyMap();
        }

        @Override
        public Map<Class, Subgraph> getKeySubgraphs() {
            return Collections.emptyMap();
        }

        public String toString() {
            return "Mocked NON-EXIST attribute node";
        }
    };
    private static final GraphNodeImplementor NON_EXIST_SUBGRAPH_NODE = new GraphNodeImplementor(){

        @Override
        public List<AttributeNodeImplementor<?>> attributeImplementorNodes() {
            return Collections.emptyList();
        }

        @Override
        public List<AttributeNode<?>> attributeNodes() {
            return Collections.emptyList();
        }

        @Override
        public boolean containsAttribute(String name) {
            return false;
        }
    };

    protected AbstractEntityGraphVisitationStrategy(SessionFactoryImplementor sessionFactory, LoadQueryInfluencers loadQueryInfluencers, LockMode lockMode) {
        super(sessionFactory);
        this.loadQueryInfluencers = loadQueryInfluencers;
        this.lockMode = lockMode;
    }

    @Override
    public void start() {
        super.start();
        this.graphStack.addLast(this.getRootEntityGraph());
    }

    @Override
    public void finish() {
        super.finish();
        this.graphStack.removeLast();
        if (!(this.graphStack.isEmpty() && this.attributeStack.isEmpty() && this.attributeMapStack.isEmpty())) {
            throw new WalkingException("Internal stack error");
        }
    }

    @Override
    public void startingEntity(EntityDefinition entityDefinition) {
        this.attributeMapStack.addLast(this.buildAttributeNodeMap());
        super.startingEntity(entityDefinition);
    }

    protected Map<String, AttributeNodeImplementor> buildAttributeNodeMap() {
        GraphNodeImplementor graphNode = this.graphStack.peekLast();
        List<AttributeNodeImplementor<?>> attributeNodeImplementors = graphNode.attributeImplementorNodes();
        HashMap<String, AttributeNodeImplementor> attributeNodeImplementorMap = attributeNodeImplementors.isEmpty() ? Collections.emptyMap() : new HashMap<String, AttributeNodeImplementor>(attributeNodeImplementors.size());
        for (AttributeNodeImplementor<?> attribute : attributeNodeImplementors) {
            attributeNodeImplementorMap.put(attribute.getAttributeName(), attribute);
        }
        return attributeNodeImplementorMap;
    }

    @Override
    public void finishingEntity(EntityDefinition entityDefinition) {
        this.attributeMapStack.removeLast();
        super.finishingEntity(entityDefinition);
    }

    @Override
    public boolean startingAttribute(AttributeDefinition attributeDefinition) {
        Map<String, AttributeNodeImplementor> attributeMap = this.attributeMapStack.peekLast();
        String attrName = attributeDefinition.getName();
        AttributeNodeImplementor attributeNode = NON_EXIST_ATTRIBUTE_NODE;
        GraphNodeImplementor subGraphNode = NON_EXIST_SUBGRAPH_NODE;
        if (attributeMap.containsKey(attrName)) {
            attributeNode = attributeMap.get(attrName);
            Map<Class, Subgraph> subGraphs = attributeNode.getSubgraphs();
            Class javaType = attributeDefinition.getType().getReturnedClass();
            if (!subGraphs.isEmpty() && subGraphs.containsKey(javaType)) {
                subGraphNode = (GraphNodeImplementor)((Object)subGraphs.get(javaType));
            }
        }
        this.attributeStack.addLast(attributeNode);
        this.graphStack.addLast(subGraphNode);
        return super.startingAttribute(attributeDefinition);
    }

    @Override
    public void finishingAttribute(AttributeDefinition attributeDefinition) {
        this.attributeStack.removeLast();
        this.graphStack.removeLast();
        super.finishingAttribute(attributeDefinition);
    }

    @Override
    public void startingCollectionElements(CollectionElementDefinition elementDefinition) {
        AttributeNodeImplementor attributeNode = this.attributeStack.peekLast();
        GraphNodeImplementor subGraphNode = NON_EXIST_SUBGRAPH_NODE;
        Map<Class, Subgraph> subGraphs = attributeNode.getSubgraphs();
        Class javaType = elementDefinition.getType().getReturnedClass();
        if (!subGraphs.isEmpty() && subGraphs.containsKey(javaType)) {
            subGraphNode = (GraphNodeImplementor)((Object)subGraphs.get(javaType));
        }
        this.graphStack.addLast(subGraphNode);
        super.startingCollectionElements(elementDefinition);
    }

    @Override
    public void finishingCollectionElements(CollectionElementDefinition elementDefinition) {
        super.finishingCollectionElements(elementDefinition);
        this.graphStack.removeLast();
    }

    @Override
    public void startingCollectionIndex(CollectionIndexDefinition indexDefinition) {
        AttributeNodeImplementor attributeNode = this.attributeStack.peekLast();
        GraphNodeImplementor subGraphNode = NON_EXIST_SUBGRAPH_NODE;
        Map<Class, Subgraph> subGraphs = attributeNode.getKeySubgraphs();
        Class javaType = indexDefinition.getType().getReturnedClass();
        if (!subGraphs.isEmpty() && subGraphs.containsKey(javaType)) {
            subGraphNode = (GraphNodeImplementor)((Object)subGraphs.get(javaType));
        }
        this.graphStack.addLast(subGraphNode);
        super.startingCollectionIndex(indexDefinition);
    }

    @Override
    public void finishingCollectionIndex(CollectionIndexDefinition indexDefinition) {
        super.finishingCollectionIndex(indexDefinition);
        this.graphStack.removeLast();
    }

    @Override
    protected boolean supportsRootCollectionReturns() {
        return false;
    }

    @Override
    protected void addRootReturn(Return rootReturn) {
        if (this.rootEntityReturn != null) {
            throw new HibernateException("Root return already identified");
        }
        if (!(rootReturn instanceof EntityReturn)) {
            throw new HibernateException("Load entity graph only supports EntityReturn");
        }
        this.rootEntityReturn = (EntityReturn)rootReturn;
    }

    @Override
    protected FetchStrategy determineFetchStrategy(AssociationAttributeDefinition attributeDefinition) {
        return this.attributeStack.peekLast() != NON_EXIST_ATTRIBUTE_NODE ? DEFAULT_EAGER : this.resolveImplicitFetchStrategyFromEntityGraph(attributeDefinition);
    }

    protected abstract FetchStrategy resolveImplicitFetchStrategyFromEntityGraph(AssociationAttributeDefinition var1);

    protected FetchStrategy adjustJoinFetchIfNeeded(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy) {
        if (this.lockMode.greaterThan(LockMode.READ)) {
            return new FetchStrategy(fetchStrategy.getTiming(), FetchStyle.SELECT);
        }
        Integer maxFetchDepth = this.sessionFactory().getSettings().getMaximumFetchDepth();
        if (maxFetchDepth != null && this.currentDepth() > maxFetchDepth) {
            return new FetchStrategy(fetchStrategy.getTiming(), FetchStyle.SELECT);
        }
        if (attributeDefinition.getType().isCollectionType() && this.isTooManyCollections()) {
            return new FetchStrategy(fetchStrategy.getTiming(), FetchStyle.SELECT);
        }
        return fetchStrategy;
    }

    @Override
    public LoadPlan buildLoadPlan() {
        LOG.debug("Building LoadPlan...");
        return new LoadPlanImpl(this.rootEntityReturn, (QuerySpaces)this.getQuerySpaces());
    }

    protected abstract GraphNodeImplementor getRootEntityGraph();

    @Override
    public void foundCircularAssociation(AssociationAttributeDefinition attributeDefinition) {
        FetchStrategy fetchStrategy = this.determineFetchStrategy(attributeDefinition);
        if (fetchStrategy.getStyle() != FetchStyle.JOIN) {
            return;
        }
        GraphNodeImplementor graphNode = this.graphStack.peekLast();
        if (attributeDefinition.getAssociationNature() == AssociationAttributeDefinition.AssociationNature.COLLECTION && !graphNode.equals(NON_EXIST_SUBGRAPH_NODE) && graphNode.containsAttribute(attributeDefinition.getName())) {
            this.currentSource().buildCollectionAttributeFetch(attributeDefinition, fetchStrategy);
        }
        super.foundCircularAssociation(attributeDefinition);
    }
}

