/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.stat.internal;

import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.evosuite.shaded.org.hibernate.boot.spi.SessionFactoryOptions;
import org.evosuite.shaded.org.hibernate.engine.config.spi.ConfigurationService;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.service.spi.ServiceRegistryImplementor;
import org.evosuite.shaded.org.hibernate.service.spi.SessionFactoryServiceInitiator;
import org.evosuite.shaded.org.hibernate.stat.internal.ConcurrentStatisticsImpl;
import org.evosuite.shaded.org.hibernate.stat.spi.StatisticsFactory;
import org.evosuite.shaded.org.hibernate.stat.spi.StatisticsImplementor;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class StatisticsInitiator
implements SessionFactoryServiceInitiator<StatisticsImplementor> {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, StatisticsInitiator.class.getName());
    public static final StatisticsInitiator INSTANCE = new StatisticsInitiator();
    public static final String STATS_BUILDER = "hibernate.stats.factory";
    private static StatisticsFactory DEFAULT_STATS_BUILDER = new StatisticsFactory(){

        @Override
        public StatisticsImplementor buildStatistics(SessionFactoryImplementor sessionFactory) {
            return new ConcurrentStatisticsImpl(sessionFactory);
        }
    };

    @Override
    public Class<StatisticsImplementor> getServiceInitiated() {
        return StatisticsImplementor.class;
    }

    @Override
    public StatisticsImplementor initiateService(SessionFactoryImplementor sessionFactory, SessionFactoryOptions sessionFactoryOptions, ServiceRegistryImplementor registry) {
        Object configValue = registry.getService(ConfigurationService.class).getSettings().get(STATS_BUILDER);
        return this.initiateServiceInternal(sessionFactory, configValue, registry);
    }

    private StatisticsImplementor initiateServiceInternal(SessionFactoryImplementor sessionFactory, Object configValue, ServiceRegistryImplementor registry) {
        StatisticsFactory statisticsFactory;
        if (configValue == null) {
            statisticsFactory = DEFAULT_STATS_BUILDER;
        } else if (StatisticsFactory.class.isInstance(configValue)) {
            statisticsFactory = (StatisticsFactory)configValue;
        } else {
            ClassLoaderService classLoaderService = registry.getService(ClassLoaderService.class);
            try {
                statisticsFactory = (StatisticsFactory)classLoaderService.classForName(configValue.toString()).newInstance();
            }
            catch (HibernateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new HibernateException("Unable to instantiate specified StatisticsFactory implementation [" + configValue.toString() + "]", e);
            }
        }
        StatisticsImplementor statistics = statisticsFactory.buildStatistics(sessionFactory);
        boolean enabled = sessionFactory.getSettings().isStatisticsEnabled();
        statistics.setStatisticsEnabled(enabled);
        LOG.debugf("Statistics initialized [enabled=%s]", (Object)enabled);
        return statistics;
    }
}

