/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.auth;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Set;
import org.evosuite.shaded.org.hsqldb.auth.AuthFunctionBean;
import org.evosuite.shaded.org.hsqldb.auth.AuthUtils;
import org.evosuite.shaded.org.hsqldb.auth.DenyException;
import org.evosuite.shaded.org.hsqldb.lib.FrameworkLogger;

public class HsqldbSlaveAuthBean
implements AuthFunctionBean {
    private static FrameworkLogger logger = FrameworkLogger.getLog(HsqldbSlaveAuthBean.class);
    private String masterJdbcUrl;
    private String validationUser;
    private String validationPassword;
    private boolean delegateRolesSchema = true;
    protected boolean initialized;

    public void setValidationUser(String string) {
        this.validationUser = string;
    }

    public void setValidationPassword(String string) {
        this.validationPassword = string;
    }

    public void setMasterJdbcUrl(String string) {
        this.masterJdbcUrl = string;
    }

    public void setDelegateRolesSchema(boolean bl) {
        this.delegateRolesSchema = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws SQLException {
        if (this.masterJdbcUrl == null) {
            throw new IllegalStateException("Required property 'masterJdbcUrl' not set");
        }
        if (this.validationUser != null || this.validationPassword != null) {
            if (this.validationUser == null || this.validationPassword == null) {
                throw new IllegalStateException("If you set one property of 'validationUser' or 'validationPassword', then you must set both.");
            }
            Connection connection = null;
            SQLException sQLException = null;
            try {
                connection = DriverManager.getConnection(this.masterJdbcUrl, this.validationUser, this.validationPassword);
            }
            catch (SQLException sQLException2) {
                logger.error("Master/slave Connection validation failure", sQLException2);
                sQLException = sQLException2;
            }
            finally {
                block16: {
                    if (connection != null) {
                        try {
                            connection.close();
                            connection = null;
                        }
                        catch (SQLException sQLException3) {
                            logger.error("Failed to close test master/slave Connection", sQLException3);
                            if (sQLException != null) break block16;
                            throw sQLException3;
                        }
                    }
                }
            }
        }
        this.initialized = true;
    }

    @Override
    public String[] authenticate(String string, String string2) throws DenyException {
        if (!this.initialized) {
            throw new IllegalStateException("You must invoke the 'init' method to initialize the " + HsqldbSlaveAuthBean.class.getName() + " instance.");
        }
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(this.masterJdbcUrl, string, string2);
            if (this.delegateRolesSchema) {
                Set set = AuthUtils.getEnabledRoles(connection);
                String string3 = AuthUtils.getInitialSchema(connection);
                if (string3 != null) {
                    set.add(string3);
                }
                logger.finer("Slave delegating schema+roles: " + set);
                String[] stringArray = set.toArray(new String[0]);
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
        catch (SQLException sQLException) {
            throw new DenyException();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                    connection = null;
                }
                catch (SQLException sQLException) {
                    logger.severe("Failed to close master/slave Connection", sQLException);
                }
            }
        }
    }
}

