/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.evosuite.shaded.org.hsqldb.lib.Collection;
import org.evosuite.shaded.org.hsqldb.lib.Iterator;

abstract class BaseList {
    protected int elementCount;

    BaseList() {
    }

    abstract Object get(int var1);

    abstract Object remove(int var1);

    abstract boolean add(Object var1);

    abstract int size();

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    public int indexOf(Object object) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Object object2 = this.get(i);
            if (!(object2 == null ? object == null : object2.equals(object))) continue;
            return i;
        }
        return -1;
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl = true;
            this.add(iterator.next());
        }
        return bl;
    }

    public boolean addAll(Object[] objectArray) {
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            bl = true;
            this.add(objectArray[i]);
        }
        return bl;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(32 + this.elementCount * 3);
        stringBuffer.append("List : size=");
        stringBuffer.append(this.elementCount);
        stringBuffer.append(' ');
        stringBuffer.append('{');
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
            stringBuffer.append(' ');
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public Iterator iterator() {
        return new BaseListIterator();
    }

    private class BaseListIterator
    implements Iterator {
        int counter = 0;
        boolean removed;

        private BaseListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.counter < BaseList.this.elementCount;
        }

        @Override
        public Object next() {
            if (this.counter < BaseList.this.elementCount) {
                this.removed = false;
                Object object = BaseList.this.get(this.counter);
                ++this.counter;
                return object;
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextInt() {
            throw new NoSuchElementException();
        }

        @Override
        public long nextLong() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.removed) {
                throw new NoSuchElementException("Iterator");
            }
            this.removed = true;
            if (this.counter != 0) {
                BaseList.this.remove(this.counter - 1);
                --this.counter;
                return;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void setValue(Object object) {
            throw new NoSuchElementException();
        }
    }
}

