/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.result.Result;
import org.evosuite.shaded.org.hsqldb.server.RecoverableOdbcFailure;
import org.evosuite.shaded.org.hsqldb.server.StatementPortal;

class OdbcPreparedStatement {
    public String handle;
    public String query;
    public Result ackResult;
    public Session session;
    private Map containingMap;
    private List portals = new ArrayList();

    protected OdbcPreparedStatement(OdbcPreparedStatement odbcPreparedStatement) {
        this.handle = odbcPreparedStatement.handle;
        this.ackResult = odbcPreparedStatement.ackResult;
    }

    public OdbcPreparedStatement(String string, String string2, Map map, Session session) throws RecoverableOdbcFailure {
        this.handle = string;
        this.query = string2;
        this.containingMap = map;
        this.session = session;
        Result result = Result.newPrepareStatementRequest();
        result.setPrepareOrExecuteProperties(string2, 0, 0, 0, 0, 0, 2, null, null);
        this.ackResult = session.execute(result);
        switch (this.ackResult.getType()) {
            case 4: {
                break;
            }
            case 2: {
                throw new RecoverableOdbcFailure(this.ackResult);
            }
            default: {
                throw new RecoverableOdbcFailure("Output Result from Statement prep is of unexpected type: " + this.ackResult.getType());
            }
        }
        map.put(string, this);
    }

    public void close() {
        this.containingMap.remove(this.handle);
        while (this.portals.size() > 0) {
            ((StatementPortal)this.portals.remove(1)).close();
        }
    }

    public void addPortal(StatementPortal statementPortal) {
        this.portals.add(statementPortal);
    }
}

