/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.types;

import java.io.IOException;
import java.io.InputStream;
import org.evosuite.shaded.org.hsqldb.SessionInterface;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.java.JavaSystem;
import org.evosuite.shaded.org.hsqldb.types.BlobData;

public class BlobInputStream
extends InputStream {
    final BlobData blob;
    final long availableLength;
    long bufferOffset;
    long currentPosition;
    byte[] buffer;
    boolean isClosed;
    int streamBlockSize;
    public final SessionInterface session;

    public BlobInputStream(SessionInterface sessionInterface, BlobData blobData, long l, long l2) {
        long l3 = blobData.length(sessionInterface);
        this.session = sessionInterface;
        this.blob = blobData;
        this.availableLength = l + Math.min(l2, l3 - l);
        this.currentPosition = l;
        this.streamBlockSize = sessionInterface.getStreamBlockSize();
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.currentPosition >= this.availableLength) {
            return -1;
        }
        if (this.buffer == null || this.currentPosition >= this.bufferOffset + (long)this.buffer.length) {
            try {
                this.checkClosed();
                this.readIntoBuffer();
            }
            catch (Exception exception) {
                throw JavaSystem.toIOException(exception);
            }
        }
        int n = this.buffer[(int)(this.currentPosition - this.bufferOffset)] & 0xFF;
        ++this.currentPosition;
        return n;
    }

    @Override
    public long skip(long l) throws IOException {
        this.checkClosed();
        if (l <= 0L) {
            return 0L;
        }
        if (this.currentPosition + l > this.availableLength) {
            l = this.availableLength - this.currentPosition;
        }
        this.currentPosition += l;
        return l;
    }

    @Override
    public int available() {
        long l = this.availableLength - this.currentPosition;
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
    }

    private void checkClosed() throws IOException {
        if (this.isClosed || this.blob.isClosed()) {
            throw new IOException(Error.getMessage(1853));
        }
    }

    private void readIntoBuffer() {
        long l = this.availableLength - this.currentPosition;
        if (l <= 0L) {
            return;
        }
        if (l > (long)this.streamBlockSize) {
            l = this.streamBlockSize;
        }
        this.buffer = this.blob.getBytes(this.session, this.currentPosition, (int)l);
        this.bufferOffset = this.currentPosition;
    }

    static boolean isInLimits(long l, long l2, long l3) {
        return l2 >= 0L && l3 >= 0L && l2 + l3 <= l;
    }
}

