/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal;

import java.util.Arrays;
import java.util.List;
import org.evosuite.shaded.org.mockito.InOrder;
import org.evosuite.shaded.org.mockito.MockSettings;
import org.evosuite.shaded.org.mockito.MockingDetails;
import org.evosuite.shaded.org.mockito.exceptions.misusing.NotAMockException;
import org.evosuite.shaded.org.mockito.internal.InOrderImpl;
import org.evosuite.shaded.org.mockito.internal.creation.MockSettingsImpl;
import org.evosuite.shaded.org.mockito.internal.exceptions.Reporter;
import org.evosuite.shaded.org.mockito.internal.invocation.finder.VerifiableInvocationsFinder;
import org.evosuite.shaded.org.mockito.internal.listeners.VerificationStartedNotifier;
import org.evosuite.shaded.org.mockito.internal.progress.MockingProgress;
import org.evosuite.shaded.org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.evosuite.shaded.org.mockito.internal.stubbing.InvocationContainerImpl;
import org.evosuite.shaded.org.mockito.internal.stubbing.OngoingStubbingImpl;
import org.evosuite.shaded.org.mockito.internal.stubbing.StubberImpl;
import org.evosuite.shaded.org.mockito.internal.util.DefaultMockingDetails;
import org.evosuite.shaded.org.mockito.internal.util.MockUtil;
import org.evosuite.shaded.org.mockito.internal.verification.MockAwareVerificationMode;
import org.evosuite.shaded.org.mockito.internal.verification.VerificationDataImpl;
import org.evosuite.shaded.org.mockito.internal.verification.VerificationModeFactory;
import org.evosuite.shaded.org.mockito.internal.verification.api.InOrderContext;
import org.evosuite.shaded.org.mockito.internal.verification.api.VerificationDataInOrderImpl;
import org.evosuite.shaded.org.mockito.invocation.Invocation;
import org.evosuite.shaded.org.mockito.invocation.MockHandler;
import org.evosuite.shaded.org.mockito.mock.MockCreationSettings;
import org.evosuite.shaded.org.mockito.stubbing.OngoingStubbing;
import org.evosuite.shaded.org.mockito.stubbing.Stubber;
import org.evosuite.shaded.org.mockito.verification.VerificationMode;

public class MockitoCore {
    public boolean isTypeMockable(Class<?> typeToMock) {
        return MockUtil.typeMockabilityOf(typeToMock).mockable();
    }

    public <T> T mock(Class<T> typeToMock, MockSettings settings) {
        if (!MockSettingsImpl.class.isInstance(settings)) {
            throw new IllegalArgumentException("Unexpected implementation of '" + settings.getClass().getCanonicalName() + "'\nAt the moment, you cannot provide your own implementations of that class.");
        }
        MockSettingsImpl impl = (MockSettingsImpl)MockSettingsImpl.class.cast(settings);
        MockCreationSettings<T> creationSettings = impl.build(typeToMock);
        T mock = MockUtil.createMock(creationSettings);
        ThreadSafeMockingProgress.mockingProgress().mockingStarted(mock, creationSettings);
        return mock;
    }

    public <T> OngoingStubbing<T> when(T methodCall) {
        MockingProgress mockingProgress = ThreadSafeMockingProgress.mockingProgress();
        mockingProgress.stubbingStarted();
        OngoingStubbing<?> stubbing = mockingProgress.pullOngoingStubbing();
        if (stubbing == null) {
            mockingProgress.reset();
            throw Reporter.missingMethodInvocation();
        }
        return stubbing;
    }

    public <T> T verify(T mock, VerificationMode mode) {
        if (mock == null) {
            throw Reporter.nullPassedToVerify();
        }
        MockingDetails mockingDetails = this.mockingDetails(mock);
        if (!mockingDetails.isMock()) {
            throw Reporter.notAMockPassedToVerify(mock.getClass());
        }
        MockHandler handler = mockingDetails.getMockHandler();
        mock = VerificationStartedNotifier.notifyVerificationStarted(handler.getMockSettings().getVerificationStartedListeners(), mockingDetails);
        MockingProgress mockingProgress = ThreadSafeMockingProgress.mockingProgress();
        VerificationMode actualMode = mockingProgress.maybeVerifyLazily(mode);
        mockingProgress.verificationStarted(new MockAwareVerificationMode(mock, actualMode, mockingProgress.verificationListeners()));
        return mock;
    }

    public <T> void reset(T ... mocks) {
        MockingProgress mockingProgress = ThreadSafeMockingProgress.mockingProgress();
        mockingProgress.validateState();
        mockingProgress.reset();
        mockingProgress.resetOngoingStubbing();
        for (T m : mocks) {
            MockUtil.resetMock(m);
        }
    }

    public <T> void clearInvocations(T ... mocks) {
        MockingProgress mockingProgress = ThreadSafeMockingProgress.mockingProgress();
        mockingProgress.validateState();
        mockingProgress.reset();
        mockingProgress.resetOngoingStubbing();
        for (T m : mocks) {
            MockUtil.getInvocationContainer(m).clearInvocations();
        }
    }

    public void verifyNoMoreInteractions(Object ... mocks) {
        this.assertMocksNotEmpty(mocks);
        ThreadSafeMockingProgress.mockingProgress().validateState();
        for (Object mock : mocks) {
            try {
                if (mock == null) {
                    throw Reporter.nullPassedToVerifyNoMoreInteractions();
                }
                InvocationContainerImpl invocations = MockUtil.getInvocationContainer(mock);
                VerificationDataImpl data = new VerificationDataImpl(invocations, null);
                VerificationModeFactory.noMoreInteractions().verify(data);
            }
            catch (NotAMockException e) {
                throw Reporter.notAMockPassedToVerifyNoMoreInteractions();
            }
        }
    }

    public void verifyNoMoreInteractionsInOrder(List<Object> mocks, InOrderContext inOrderContext) {
        ThreadSafeMockingProgress.mockingProgress().validateState();
        VerificationDataInOrderImpl data = new VerificationDataInOrderImpl(inOrderContext, VerifiableInvocationsFinder.find(mocks), null);
        VerificationModeFactory.noMoreInteractions().verifyInOrder(data);
    }

    private void assertMocksNotEmpty(Object[] mocks) {
        if (mocks == null || mocks.length == 0) {
            throw Reporter.mocksHaveToBePassedToVerifyNoMoreInteractions();
        }
    }

    public InOrder inOrder(Object ... mocks) {
        if (mocks == null || mocks.length == 0) {
            throw Reporter.mocksHaveToBePassedWhenCreatingInOrder();
        }
        for (Object mock : mocks) {
            if (mock == null) {
                throw Reporter.nullPassedWhenCreatingInOrder();
            }
            if (MockUtil.isMock(mock)) continue;
            throw Reporter.notAMockPassedWhenCreatingInOrder();
        }
        return new InOrderImpl(Arrays.asList(mocks));
    }

    public Stubber stubber() {
        MockingProgress mockingProgress = ThreadSafeMockingProgress.mockingProgress();
        mockingProgress.stubbingStarted();
        mockingProgress.resetOngoingStubbing();
        return new StubberImpl();
    }

    public void validateMockitoUsage() {
        ThreadSafeMockingProgress.mockingProgress().validateState();
    }

    public Invocation getLastInvocation() {
        OngoingStubbingImpl ongoingStubbing = (OngoingStubbingImpl)ThreadSafeMockingProgress.mockingProgress().pullOngoingStubbing();
        List<Invocation> allInvocations = ongoingStubbing.getRegisteredInvocations();
        return allInvocations.get(allInvocations.size() - 1);
    }

    public Object[] ignoreStubs(Object ... mocks) {
        for (Object m : mocks) {
            InvocationContainerImpl container = MockUtil.getInvocationContainer(m);
            List<Invocation> ins = container.getInvocations();
            for (Invocation in : ins) {
                if (in.stubInfo() == null) continue;
                in.ignoreForVerification();
            }
        }
        return mocks;
    }

    public MockingDetails mockingDetails(Object toInspect) {
        return new DefaultMockingDetails(toInspect);
    }
}

