/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.matchers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.evosuite.shaded.org.mockito.ArgumentMatcher;
import org.evosuite.shaded.org.mockito.internal.exceptions.Reporter;
import org.evosuite.shaded.org.mockito.internal.matchers.CapturesArguments;
import org.evosuite.shaded.org.mockito.internal.matchers.VarargMatcher;

public class CapturingMatcher<T>
implements ArgumentMatcher<T>,
CapturesArguments,
VarargMatcher,
Serializable {
    private final List<Object> arguments = new ArrayList<Object>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();

    @Override
    public boolean matches(Object argument) {
        return true;
    }

    public String toString() {
        return "<Capturing argument>";
    }

    public T getLastValue() {
        this.readLock.lock();
        try {
            if (this.arguments.isEmpty()) {
                throw Reporter.noArgumentValueWasCaptured();
            }
            Object object = this.arguments.get(this.arguments.size() - 1);
            return (T)object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<T> getAllValues() {
        this.readLock.lock();
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>(this.arguments);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void captureFrom(Object argument) {
        this.writeLock.lock();
        try {
            this.arguments.add(argument);
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

