/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.beans.factory.support;

import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.evosuite.shaded.org.springframework.beans.BeanMetadataElement;
import org.evosuite.shaded.org.springframework.beans.BeanWrapper;
import org.evosuite.shaded.org.springframework.beans.BeanWrapperImpl;
import org.evosuite.shaded.org.springframework.beans.BeansException;
import org.evosuite.shaded.org.springframework.beans.TypeConverter;
import org.evosuite.shaded.org.springframework.beans.TypeMismatchException;
import org.evosuite.shaded.org.springframework.beans.factory.BeanCreationException;
import org.evosuite.shaded.org.springframework.beans.factory.BeanDefinitionStoreException;
import org.evosuite.shaded.org.springframework.beans.factory.BeanFactory;
import org.evosuite.shaded.org.springframework.beans.factory.InjectionPoint;
import org.evosuite.shaded.org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.evosuite.shaded.org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.evosuite.shaded.org.springframework.beans.factory.config.DependencyDescriptor;
import org.evosuite.shaded.org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.evosuite.shaded.org.springframework.beans.factory.support.AutowireUtils;
import org.evosuite.shaded.org.springframework.beans.factory.support.BeanDefinitionValueResolver;
import org.evosuite.shaded.org.springframework.beans.factory.support.RootBeanDefinition;
import org.evosuite.shaded.org.springframework.core.GenericTypeResolver;
import org.evosuite.shaded.org.springframework.core.MethodParameter;
import org.evosuite.shaded.org.springframework.core.NamedThreadLocal;
import org.evosuite.shaded.org.springframework.core.ParameterNameDiscoverer;
import org.evosuite.shaded.org.springframework.util.ClassUtils;
import org.evosuite.shaded.org.springframework.util.MethodInvoker;
import org.evosuite.shaded.org.springframework.util.ObjectUtils;
import org.evosuite.shaded.org.springframework.util.ReflectionUtils;
import org.evosuite.shaded.org.springframework.util.StringUtils;

class ConstructorResolver {
    private static final NamedThreadLocal<InjectionPoint> currentInjectionPoint = new NamedThreadLocal("Current injection point");
    private final AbstractAutowireCapableBeanFactory beanFactory;

    public ConstructorResolver(AbstractAutowireCapableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public BeanWrapper autowireConstructor(final String beanName, final RootBeanDefinition mbd, Constructor<?>[] chosenCtors, Object[] explicitArgs) {
        Object[] argsToUse;
        Constructor<?> constructorToUse;
        BeanWrapperImpl bw;
        block38: {
            void var18_27;
            int minNrOfArgs;
            bw = new BeanWrapperImpl();
            this.beanFactory.initBeanWrapper(bw);
            constructorToUse = null;
            ArgumentsHolder argsHolderToUse = null;
            argsToUse = null;
            if (explicitArgs != null) {
                argsToUse = explicitArgs;
            } else {
                Object[] argsToResolve = null;
                Object object = mbd.constructorArgumentLock;
                synchronized (object) {
                    constructorToUse = (Constructor<?>)mbd.resolvedConstructorOrFactoryMethod;
                    if (constructorToUse != null && mbd.constructorArgumentsResolved && (argsToUse = mbd.resolvedConstructorArguments) == null) {
                        argsToResolve = mbd.preparedConstructorArguments;
                    }
                }
                if (argsToResolve != null) {
                    argsToUse = this.resolvePreparedArguments(beanName, mbd, bw, constructorToUse, argsToResolve);
                }
            }
            if (constructorToUse != null) break block38;
            boolean autowiring = chosenCtors != null || mbd.getResolvedAutowireMode() == 3;
            ConstructorArgumentValues resolvedValues = null;
            if (explicitArgs != null) {
                minNrOfArgs = explicitArgs.length;
            } else {
                ConstructorArgumentValues cargs = mbd.getConstructorArgumentValues();
                resolvedValues = new ConstructorArgumentValues();
                minNrOfArgs = this.resolveConstructorArguments(beanName, mbd, bw, cargs, resolvedValues);
            }
            Constructor<?>[] candidates = chosenCtors;
            if (candidates == null) {
                Class<?> beanClass = mbd.getBeanClass();
                try {
                    candidates = mbd.isNonPublicAccessAllowed() ? beanClass.getDeclaredConstructors() : beanClass.getConstructors();
                }
                catch (Throwable ex) {
                    throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Resolution of declared constructors on bean Class [" + beanClass.getName() + "] from ClassLoader [" + beanClass.getClassLoader() + "] failed", ex);
                }
            }
            AutowireUtils.sortConstructors(candidates);
            int minTypeDiffWeight = Integer.MAX_VALUE;
            LinkedHashSet ambiguousConstructors = null;
            LinkedList<UnsatisfiedDependencyException> causes = null;
            Constructor<?>[] constructorArray = candidates;
            int n = constructorArray.length;
            boolean bl = false;
            while (var18_27 < n) {
                block37: {
                    int typeDiffWeight;
                    ArgumentsHolder argsHolder;
                    Class<?>[] paramTypes;
                    Constructor<?> candidate;
                    block36: {
                        candidate = constructorArray[var18_27];
                        paramTypes = candidate.getParameterTypes();
                        if (constructorToUse != null && argsToUse.length > paramTypes.length) break;
                        if (paramTypes.length < minNrOfArgs) break block37;
                        if (resolvedValues != null) {
                            try {
                                ParameterNameDiscoverer pnd;
                                String[] paramNames = ConstructorPropertiesChecker.evaluate(candidate, paramTypes.length);
                                if (paramNames == null && (pnd = this.beanFactory.getParameterNameDiscoverer()) != null) {
                                    paramNames = pnd.getParameterNames(candidate);
                                }
                                argsHolder = this.createArgumentArray(beanName, mbd, resolvedValues, bw, paramTypes, paramNames, this.getUserDeclaredConstructor(candidate), autowiring);
                                break block36;
                            }
                            catch (UnsatisfiedDependencyException ex) {
                                if (this.beanFactory.logger.isTraceEnabled()) {
                                    this.beanFactory.logger.trace("Ignoring constructor [" + candidate + "] of bean '" + beanName + "': " + ex);
                                }
                                if (causes == null) {
                                    causes = new LinkedList<UnsatisfiedDependencyException>();
                                }
                                causes.add(ex);
                                break block37;
                            }
                        }
                        if (paramTypes.length != explicitArgs.length) break block37;
                        argsHolder = new ArgumentsHolder(explicitArgs);
                    }
                    int n2 = typeDiffWeight = mbd.isLenientConstructorResolution() ? argsHolder.getTypeDifferenceWeight(paramTypes) : argsHolder.getAssignabilityWeight(paramTypes);
                    if (typeDiffWeight < minTypeDiffWeight) {
                        constructorToUse = candidate;
                        argsHolderToUse = argsHolder;
                        argsToUse = argsHolder.arguments;
                        minTypeDiffWeight = typeDiffWeight;
                        ambiguousConstructors = null;
                    } else if (constructorToUse != null && typeDiffWeight == minTypeDiffWeight) {
                        if (ambiguousConstructors == null) {
                            ambiguousConstructors = new LinkedHashSet();
                            ambiguousConstructors.add(constructorToUse);
                        }
                        ambiguousConstructors.add(candidate);
                    }
                }
                ++var18_27;
            }
            if (constructorToUse == null) {
                if (causes != null) {
                    UnsatisfiedDependencyException ex = (UnsatisfiedDependencyException)causes.removeLast();
                    for (Exception exception : causes) {
                        this.beanFactory.onSuppressedException(exception);
                    }
                    throw ex;
                }
                throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Could not resolve matching constructor (hint: specify index/type/name arguments for simple parameters to avoid type ambiguities)");
            }
            if (ambiguousConstructors != null && !mbd.isLenientConstructorResolution()) {
                throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Ambiguous constructor matches found in bean '" + beanName + "' (hint: specify index/type/name arguments for simple parameters to avoid type ambiguities): " + ambiguousConstructors);
            }
            if (explicitArgs == null) {
                argsHolderToUse.storeCache(mbd, constructorToUse);
            }
        }
        try {
            Object beanInstance;
            if (System.getSecurityManager() != null) {
                final Constructor<?> ctorToUse = constructorToUse;
                final Object[] argumentsToUse = argsToUse;
                beanInstance = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return ConstructorResolver.this.beanFactory.getInstantiationStrategy().instantiate(mbd, beanName, (BeanFactory)ConstructorResolver.this.beanFactory, ctorToUse, argumentsToUse);
                    }
                }, this.beanFactory.getAccessControlContext());
            } else {
                beanInstance = this.beanFactory.getInstantiationStrategy().instantiate(mbd, beanName, (BeanFactory)this.beanFactory, constructorToUse, argsToUse);
            }
            bw.setBeanInstance(beanInstance);
            return bw;
        }
        catch (Throwable ex) {
            throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Bean instantiation via constructor failed", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveFactoryMethodIfPossible(RootBeanDefinition mbd) {
        boolean isStatic;
        Class<?> factoryClass;
        if (mbd.getFactoryBeanName() != null) {
            factoryClass = this.beanFactory.getType(mbd.getFactoryBeanName());
            isStatic = false;
        } else {
            factoryClass = mbd.getBeanClass();
            isStatic = true;
        }
        factoryClass = ClassUtils.getUserClass(factoryClass);
        Method[] candidates = this.getCandidateMethods(factoryClass, mbd);
        Method uniqueCandidate = null;
        for (Method candidate : candidates) {
            if (Modifier.isStatic(candidate.getModifiers()) != isStatic || !mbd.isFactoryMethod(candidate)) continue;
            if (uniqueCandidate == null) {
                uniqueCandidate = candidate;
                continue;
            }
            if (Arrays.equals(uniqueCandidate.getParameterTypes(), candidate.getParameterTypes())) continue;
            uniqueCandidate = null;
            break;
        }
        Object object = mbd.constructorArgumentLock;
        synchronized (object) {
            mbd.resolvedConstructorOrFactoryMethod = uniqueCandidate;
        }
    }

    private Method[] getCandidateMethods(final Class<?> factoryClass, final RootBeanDefinition mbd) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                @Override
                public Method[] run() {
                    return mbd.isNonPublicAccessAllowed() ? ReflectionUtils.getAllDeclaredMethods(factoryClass) : factoryClass.getMethods();
                }
            });
        }
        return mbd.isNonPublicAccessAllowed() ? ReflectionUtils.getAllDeclaredMethods(factoryClass) : factoryClass.getMethods();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public BeanWrapper instantiateUsingFactoryMethod(final String beanName, final RootBeanDefinition mbd, Object[] explicitArgs) {
        Object[] argsToUse;
        Method factoryMethodToUse;
        Object factoryBean;
        BeanWrapperImpl bw;
        block48: {
            void var23_30;
            int minNrOfArgs;
            boolean isStatic;
            Class<?> factoryClass;
            bw = new BeanWrapperImpl();
            this.beanFactory.initBeanWrapper(bw);
            String factoryBeanName = mbd.getFactoryBeanName();
            if (factoryBeanName != null) {
                if (factoryBeanName.equals(beanName)) {
                    throw new BeanDefinitionStoreException(mbd.getResourceDescription(), beanName, "factory-bean reference points back to the same bean definition");
                }
                factoryBean = this.beanFactory.getBean(factoryBeanName);
                if (factoryBean == null) {
                    throw new BeanCreationException(mbd.getResourceDescription(), beanName, "factory-bean '" + factoryBeanName + "' (or a BeanPostProcessor involved) returned null");
                }
                if (mbd.isSingleton() && this.beanFactory.containsSingleton(beanName)) {
                    throw new IllegalStateException("About-to-be-created singleton instance implicitly appeared through the creation of the factory bean that its bean definition points to");
                }
                factoryClass = factoryBean.getClass();
                isStatic = false;
            } else {
                if (!mbd.hasBeanClass()) {
                    throw new BeanDefinitionStoreException(mbd.getResourceDescription(), beanName, "bean definition declares neither a bean class nor a factory-bean reference");
                }
                factoryBean = null;
                factoryClass = mbd.getBeanClass();
                isStatic = true;
            }
            factoryMethodToUse = null;
            ArgumentsHolder argsHolderToUse = null;
            argsToUse = null;
            if (explicitArgs != null) {
                argsToUse = explicitArgs;
            } else {
                Object[] argsToResolve = null;
                Object object = mbd.constructorArgumentLock;
                synchronized (object) {
                    factoryMethodToUse = (Method)mbd.resolvedConstructorOrFactoryMethod;
                    if (factoryMethodToUse != null && mbd.constructorArgumentsResolved && (argsToUse = mbd.resolvedConstructorArguments) == null) {
                        argsToResolve = mbd.preparedConstructorArguments;
                    }
                }
                if (argsToResolve != null) {
                    argsToUse = this.resolvePreparedArguments(beanName, mbd, bw, factoryMethodToUse, argsToResolve);
                }
            }
            if (factoryMethodToUse != null && argsToUse != null) break block48;
            factoryClass = ClassUtils.getUserClass(factoryClass);
            Method[] rawCandidates = this.getCandidateMethods(factoryClass, mbd);
            ArrayList<Method> candidateSet = new ArrayList<Method>();
            for (Method candidate : rawCandidates) {
                if (Modifier.isStatic(candidate.getModifiers()) != isStatic || !mbd.isFactoryMethod(candidate)) continue;
                candidateSet.add(candidate);
            }
            Method[] candidates = candidateSet.toArray(new Method[candidateSet.size()]);
            AutowireUtils.sortFactoryMethods(candidates);
            ConstructorArgumentValues resolvedValues = null;
            boolean autowiring = mbd.getResolvedAutowireMode() == 3;
            int minTypeDiffWeight = Integer.MAX_VALUE;
            LinkedHashSet<Method> ambiguousFactoryMethods = null;
            if (explicitArgs != null) {
                minNrOfArgs = explicitArgs.length;
            } else {
                ConstructorArgumentValues cargs = mbd.getConstructorArgumentValues();
                resolvedValues = new ConstructorArgumentValues();
                minNrOfArgs = this.resolveConstructorArguments(beanName, mbd, bw, cargs, resolvedValues);
            }
            LinkedList<UnsatisfiedDependencyException> causes = null;
            Method[] methodArray = candidates;
            int n = methodArray.length;
            boolean bl = false;
            while (var23_30 < n) {
                block47: {
                    int typeDiffWeight;
                    ArgumentsHolder argsHolder;
                    Object[] paramTypes;
                    Method candidate;
                    block46: {
                        candidate = methodArray[var23_30];
                        paramTypes = candidate.getParameterTypes();
                        if (paramTypes.length < minNrOfArgs) break block47;
                        if (resolvedValues != null) {
                            try {
                                String[] paramNames = null;
                                ParameterNameDiscoverer pnd = this.beanFactory.getParameterNameDiscoverer();
                                if (pnd != null) {
                                    paramNames = pnd.getParameterNames(candidate);
                                }
                                argsHolder = this.createArgumentArray(beanName, mbd, resolvedValues, bw, (Class<?>[])paramTypes, paramNames, candidate, autowiring);
                                break block46;
                            }
                            catch (UnsatisfiedDependencyException ex) {
                                if (this.beanFactory.logger.isTraceEnabled()) {
                                    this.beanFactory.logger.trace("Ignoring factory method [" + candidate + "] of bean '" + beanName + "': " + ex);
                                }
                                if (causes == null) {
                                    causes = new LinkedList<UnsatisfiedDependencyException>();
                                }
                                causes.add(ex);
                                break block47;
                            }
                        }
                        if (paramTypes.length != explicitArgs.length) break block47;
                        argsHolder = new ArgumentsHolder(explicitArgs);
                    }
                    int n2 = typeDiffWeight = mbd.isLenientConstructorResolution() ? argsHolder.getTypeDifferenceWeight((Class<?>[])paramTypes) : argsHolder.getAssignabilityWeight((Class<?>[])paramTypes);
                    if (typeDiffWeight < minTypeDiffWeight) {
                        factoryMethodToUse = candidate;
                        argsHolderToUse = argsHolder;
                        argsToUse = argsHolder.arguments;
                        minTypeDiffWeight = typeDiffWeight;
                        ambiguousFactoryMethods = null;
                    } else if (factoryMethodToUse != null && typeDiffWeight == minTypeDiffWeight && !mbd.isLenientConstructorResolution() && paramTypes.length == factoryMethodToUse.getParameterTypes().length && !Arrays.equals(paramTypes, factoryMethodToUse.getParameterTypes())) {
                        if (ambiguousFactoryMethods == null) {
                            ambiguousFactoryMethods = new LinkedHashSet<Method>();
                            ambiguousFactoryMethods.add(factoryMethodToUse);
                        }
                        ambiguousFactoryMethods.add(candidate);
                    }
                }
                ++var23_30;
            }
            if (factoryMethodToUse == null) {
                if (causes != null) {
                    UnsatisfiedDependencyException ex = (UnsatisfiedDependencyException)causes.removeLast();
                    for (Exception exception : causes) {
                        this.beanFactory.onSuppressedException(exception);
                    }
                    throw ex;
                }
                ArrayList<String> argTypes = new ArrayList<String>(minNrOfArgs);
                if (explicitArgs != null) {
                    for (Object arg : explicitArgs) {
                        argTypes.add(arg != null ? arg.getClass().getSimpleName() : "null");
                    }
                } else {
                    LinkedHashSet<ConstructorArgumentValues.ValueHolder> valueHolders = new LinkedHashSet<ConstructorArgumentValues.ValueHolder>(resolvedValues.getArgumentCount());
                    valueHolders.addAll(resolvedValues.getIndexedArgumentValues().values());
                    valueHolders.addAll(resolvedValues.getGenericArgumentValues());
                    for (ConstructorArgumentValues.ValueHolder value : valueHolders) {
                        String argType = value.getType() != null ? ClassUtils.getShortName(value.getType()) : (value.getValue() != null ? value.getValue().getClass().getSimpleName() : "null");
                        argTypes.add(argType);
                    }
                }
                String argDesc = StringUtils.collectionToCommaDelimitedString(argTypes);
                throw new BeanCreationException(mbd.getResourceDescription(), beanName, "No matching factory method found: " + (mbd.getFactoryBeanName() != null ? "factory bean '" + mbd.getFactoryBeanName() + "'; " : "") + "factory method '" + mbd.getFactoryMethodName() + "(" + argDesc + ")'. Check that a method with the specified name " + (minNrOfArgs > 0 ? "and arguments " : "") + "exists and that it is " + (isStatic ? "static" : "non-static") + ".");
            }
            if (Void.TYPE == factoryMethodToUse.getReturnType()) {
                throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Invalid factory method '" + mbd.getFactoryMethodName() + "': needs to have a non-void return type!");
            }
            if (ambiguousFactoryMethods != null) {
                throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Ambiguous factory method matches found in bean '" + beanName + "' (hint: specify index/type/name arguments for simple parameters to avoid type ambiguities): " + ambiguousFactoryMethods);
            }
            if (explicitArgs == null && argsHolderToUse != null) {
                argsHolderToUse.storeCache(mbd, factoryMethodToUse);
            }
        }
        try {
            Object beanInstance;
            if (System.getSecurityManager() != null) {
                final Object fb = factoryBean;
                final Method factoryMethod = factoryMethodToUse;
                final Object[] args = argsToUse;
                beanInstance = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return ConstructorResolver.this.beanFactory.getInstantiationStrategy().instantiate(mbd, beanName, (BeanFactory)ConstructorResolver.this.beanFactory, fb, factoryMethod, args);
                    }
                }, this.beanFactory.getAccessControlContext());
            } else {
                beanInstance = this.beanFactory.getInstantiationStrategy().instantiate(mbd, beanName, (BeanFactory)this.beanFactory, factoryBean, factoryMethodToUse, argsToUse);
            }
            if (beanInstance == null) {
                return null;
            }
            bw.setBeanInstance(beanInstance);
            return bw;
        }
        catch (Throwable ex) {
            throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Bean instantiation via factory method failed", ex);
        }
    }

    private int resolveConstructorArguments(String beanName, RootBeanDefinition mbd, BeanWrapper bw, ConstructorArgumentValues cargs, ConstructorArgumentValues resolvedValues) {
        TypeConverter customConverter = this.beanFactory.getCustomTypeConverter();
        TypeConverter converter = customConverter != null ? customConverter : bw;
        BeanDefinitionValueResolver valueResolver = new BeanDefinitionValueResolver(this.beanFactory, beanName, mbd, converter);
        int minNrOfArgs = cargs.getArgumentCount();
        for (Map.Entry<Integer, ConstructorArgumentValues.ValueHolder> entry : cargs.getIndexedArgumentValues().entrySet()) {
            ConstructorArgumentValues.ValueHolder valueHolder;
            int index = entry.getKey();
            if (index < 0) {
                throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Invalid constructor argument index: " + index);
            }
            if (index > minNrOfArgs) {
                minNrOfArgs = index + 1;
            }
            if ((valueHolder = entry.getValue()).isConverted()) {
                resolvedValues.addIndexedArgumentValue(index, valueHolder);
                continue;
            }
            Object resolvedValue = valueResolver.resolveValueIfNecessary("constructor argument", valueHolder.getValue());
            ConstructorArgumentValues.ValueHolder resolvedValueHolder = new ConstructorArgumentValues.ValueHolder(resolvedValue, valueHolder.getType(), valueHolder.getName());
            resolvedValueHolder.setSource(valueHolder);
            resolvedValues.addIndexedArgumentValue(index, resolvedValueHolder);
        }
        for (ConstructorArgumentValues.ValueHolder valueHolder : cargs.getGenericArgumentValues()) {
            if (valueHolder.isConverted()) {
                resolvedValues.addGenericArgumentValue(valueHolder);
                continue;
            }
            Object resolvedValue = valueResolver.resolveValueIfNecessary("constructor argument", valueHolder.getValue());
            ConstructorArgumentValues.ValueHolder resolvedValueHolder = new ConstructorArgumentValues.ValueHolder(resolvedValue, valueHolder.getType(), valueHolder.getName());
            resolvedValueHolder.setSource(valueHolder);
            resolvedValues.addGenericArgumentValue(resolvedValueHolder);
        }
        return minNrOfArgs;
    }

    private ArgumentsHolder createArgumentArray(String beanName, RootBeanDefinition mbd, ConstructorArgumentValues resolvedValues, BeanWrapper bw, Class<?>[] paramTypes, String[] paramNames, Object methodOrCtor, boolean autowiring) throws UnsatisfiedDependencyException {
        TypeConverter customConverter = this.beanFactory.getCustomTypeConverter();
        TypeConverter converter = customConverter != null ? customConverter : bw;
        ArgumentsHolder args = new ArgumentsHolder(paramTypes.length);
        HashSet<ConstructorArgumentValues.ValueHolder> usedValueHolders = new HashSet<ConstructorArgumentValues.ValueHolder>(paramTypes.length);
        LinkedHashSet<String> autowiredBeanNames = new LinkedHashSet<String>(4);
        for (int paramIndex = 0; paramIndex < paramTypes.length; ++paramIndex) {
            Class<?> paramType = paramTypes[paramIndex];
            String paramName = paramNames != null ? paramNames[paramIndex] : "";
            ConstructorArgumentValues.ValueHolder valueHolder = resolvedValues.getArgumentValue(paramIndex, paramType, paramName, usedValueHolders);
            if (!(valueHolder != null || autowiring && paramTypes.length != resolvedValues.getArgumentCount())) {
                valueHolder = resolvedValues.getGenericArgumentValue(null, null, usedValueHolders);
            }
            if (valueHolder != null) {
                Object convertedValue;
                usedValueHolders.add(valueHolder);
                Object originalValue = valueHolder.getValue();
                if (valueHolder.isConverted()) {
                    args.preparedArguments[paramIndex] = convertedValue = valueHolder.getConvertedValue();
                } else {
                    ConstructorArgumentValues.ValueHolder sourceHolder = (ConstructorArgumentValues.ValueHolder)valueHolder.getSource();
                    Object sourceValue = sourceHolder.getValue();
                    MethodParameter methodParam = MethodParameter.forMethodOrConstructor(methodOrCtor, paramIndex);
                    try {
                        convertedValue = converter.convertIfNecessary(originalValue, paramType, methodParam);
                        args.resolveNecessary = true;
                        args.preparedArguments[paramIndex] = sourceValue;
                    }
                    catch (TypeMismatchException ex) {
                        throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, new InjectionPoint(methodParam), "Could not convert argument value of type [" + ObjectUtils.nullSafeClassName(valueHolder.getValue()) + "] to required type [" + paramType.getName() + "]: " + ex.getMessage());
                    }
                }
                args.arguments[paramIndex] = convertedValue;
                args.rawArguments[paramIndex] = originalValue;
                continue;
            }
            MethodParameter methodParam = MethodParameter.forMethodOrConstructor(methodOrCtor, paramIndex);
            if (!autowiring) {
                throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, new InjectionPoint(methodParam), "Ambiguous argument values for parameter of type [" + paramType.getName() + "] - did you specify the correct bean references as arguments?");
            }
            try {
                Object autowiredArgument;
                args.rawArguments[paramIndex] = autowiredArgument = this.resolveAutowiredArgument(methodParam, beanName, autowiredBeanNames, converter);
                args.arguments[paramIndex] = autowiredArgument;
                args.preparedArguments[paramIndex] = new AutowiredArgumentMarker();
                args.resolveNecessary = true;
                continue;
            }
            catch (BeansException ex) {
                throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, new InjectionPoint(methodParam), ex);
            }
        }
        for (String autowiredBeanName : autowiredBeanNames) {
            this.beanFactory.registerDependentBean(autowiredBeanName, beanName);
            if (!this.beanFactory.logger.isDebugEnabled()) continue;
            this.beanFactory.logger.debug("Autowiring by type from bean name '" + beanName + "' via " + (methodOrCtor instanceof Constructor ? "constructor" : "factory method") + " to bean named '" + autowiredBeanName + "'");
        }
        return args;
    }

    private Object[] resolvePreparedArguments(String beanName, RootBeanDefinition mbd, BeanWrapper bw, Member methodOrCtor, Object[] argsToResolve) {
        TypeConverter customConverter = this.beanFactory.getCustomTypeConverter();
        TypeConverter converter = customConverter != null ? customConverter : bw;
        BeanDefinitionValueResolver valueResolver = new BeanDefinitionValueResolver(this.beanFactory, beanName, mbd, converter);
        Class<?>[] paramTypes = methodOrCtor instanceof Method ? ((Method)methodOrCtor).getParameterTypes() : ((Constructor)methodOrCtor).getParameterTypes();
        Object[] resolvedArgs = new Object[argsToResolve.length];
        for (int argIndex = 0; argIndex < argsToResolve.length; ++argIndex) {
            Object argValue = argsToResolve[argIndex];
            MethodParameter methodParam = MethodParameter.forMethodOrConstructor(methodOrCtor, argIndex);
            GenericTypeResolver.resolveParameterType(methodParam, methodOrCtor.getDeclaringClass());
            if (argValue instanceof AutowiredArgumentMarker) {
                argValue = this.resolveAutowiredArgument(methodParam, beanName, null, converter);
            } else if (argValue instanceof BeanMetadataElement) {
                argValue = valueResolver.resolveValueIfNecessary("constructor argument", argValue);
            } else if (argValue instanceof String) {
                argValue = this.beanFactory.evaluateBeanDefinitionString((String)argValue, mbd);
            }
            Class<?> paramType = paramTypes[argIndex];
            try {
                resolvedArgs[argIndex] = converter.convertIfNecessary(argValue, paramType, methodParam);
                continue;
            }
            catch (TypeMismatchException ex) {
                throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, new InjectionPoint(methodParam), "Could not convert argument value of type [" + ObjectUtils.nullSafeClassName(argValue) + "] to required type [" + paramType.getName() + "]: " + ex.getMessage());
            }
        }
        return resolvedArgs;
    }

    protected Constructor<?> getUserDeclaredConstructor(Constructor<?> constructor) {
        Class<?> declaringClass = constructor.getDeclaringClass();
        Class<?> userClass = ClassUtils.getUserClass(declaringClass);
        if (userClass != declaringClass) {
            try {
                return userClass.getDeclaredConstructor(constructor.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return constructor;
    }

    protected Object resolveAutowiredArgument(MethodParameter param, String beanName, Set<String> autowiredBeanNames, TypeConverter typeConverter) {
        if (InjectionPoint.class.isAssignableFrom(param.getParameterType())) {
            InjectionPoint injectionPoint = (InjectionPoint)currentInjectionPoint.get();
            if (injectionPoint == null) {
                throw new IllegalStateException("No current InjectionPoint available for " + param);
            }
            return injectionPoint;
        }
        return this.beanFactory.resolveDependency(new DependencyDescriptor(param, true), beanName, autowiredBeanNames, typeConverter);
    }

    static InjectionPoint setCurrentInjectionPoint(InjectionPoint injectionPoint) {
        InjectionPoint old = (InjectionPoint)currentInjectionPoint.get();
        if (injectionPoint != null) {
            currentInjectionPoint.set(injectionPoint);
        } else {
            currentInjectionPoint.remove();
        }
        return old;
    }

    private static class ConstructorPropertiesChecker {
        private ConstructorPropertiesChecker() {
        }

        public static String[] evaluate(Constructor<?> candidate, int paramCount) {
            ConstructorProperties cp = candidate.getAnnotation(ConstructorProperties.class);
            if (cp != null) {
                String[] names = cp.value();
                if (names.length != paramCount) {
                    throw new IllegalStateException("Constructor annotated with @ConstructorProperties but not corresponding to actual number of parameters (" + paramCount + "): " + candidate);
                }
                return names;
            }
            return null;
        }
    }

    private static class AutowiredArgumentMarker {
        private AutowiredArgumentMarker() {
        }
    }

    private static class ArgumentsHolder {
        public final Object[] rawArguments;
        public final Object[] arguments;
        public final Object[] preparedArguments;
        public boolean resolveNecessary = false;

        public ArgumentsHolder(int size) {
            this.rawArguments = new Object[size];
            this.arguments = new Object[size];
            this.preparedArguments = new Object[size];
        }

        public ArgumentsHolder(Object[] args) {
            this.rawArguments = args;
            this.arguments = args;
            this.preparedArguments = args;
        }

        public int getTypeDifferenceWeight(Class<?>[] paramTypes) {
            int typeDiffWeight = MethodInvoker.getTypeDifferenceWeight(paramTypes, this.arguments);
            int rawTypeDiffWeight = MethodInvoker.getTypeDifferenceWeight(paramTypes, this.rawArguments) - 1024;
            return rawTypeDiffWeight < typeDiffWeight ? rawTypeDiffWeight : typeDiffWeight;
        }

        public int getAssignabilityWeight(Class<?>[] paramTypes) {
            int i;
            for (i = 0; i < paramTypes.length; ++i) {
                if (ClassUtils.isAssignableValue(paramTypes[i], this.arguments[i])) continue;
                return Integer.MAX_VALUE;
            }
            for (i = 0; i < paramTypes.length; ++i) {
                if (ClassUtils.isAssignableValue(paramTypes[i], this.rawArguments[i])) continue;
                return 0x7FFFFDFF;
            }
            return 0x7FFFFBFF;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void storeCache(RootBeanDefinition mbd, Object constructorOrFactoryMethod) {
            Object object = mbd.constructorArgumentLock;
            synchronized (object) {
                mbd.resolvedConstructorOrFactoryMethod = constructorOrFactoryMethod;
                mbd.constructorArgumentsResolved = true;
                if (this.resolveNecessary) {
                    mbd.preparedConstructorArguments = this.preparedArguments;
                } else {
                    mbd.resolvedConstructorArguments = this.arguments;
                }
            }
        }
    }
}

