/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.context.expression;

import org.evosuite.shaded.org.springframework.beans.factory.BeanFactory;
import org.evosuite.shaded.org.springframework.expression.AccessException;
import org.evosuite.shaded.org.springframework.expression.EvaluationContext;
import org.evosuite.shaded.org.springframework.expression.PropertyAccessor;
import org.evosuite.shaded.org.springframework.expression.TypedValue;

public class BeanFactoryAccessor
implements PropertyAccessor {
    @Override
    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{BeanFactory.class};
    }

    @Override
    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        return ((BeanFactory)target).containsBean(name);
    }

    @Override
    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        return new TypedValue(((BeanFactory)target).getBean(name));
    }

    @Override
    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return false;
    }

    @Override
    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        throw new AccessException("Beans in a BeanFactory are read-only");
    }
}

