/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.expression.spel.support;

import java.lang.reflect.Constructor;
import org.evosuite.shaded.org.springframework.expression.AccessException;
import org.evosuite.shaded.org.springframework.expression.ConstructorExecutor;
import org.evosuite.shaded.org.springframework.expression.EvaluationContext;
import org.evosuite.shaded.org.springframework.expression.TypedValue;
import org.evosuite.shaded.org.springframework.expression.spel.support.ReflectionHelper;
import org.evosuite.shaded.org.springframework.util.ReflectionUtils;

public class ReflectiveConstructorExecutor
implements ConstructorExecutor {
    private final Constructor<?> ctor;
    private final Integer varargsPosition;

    public ReflectiveConstructorExecutor(Constructor<?> ctor) {
        this.ctor = ctor;
        if (ctor.isVarArgs()) {
            Class<?>[] paramTypes = ctor.getParameterTypes();
            this.varargsPosition = paramTypes.length - 1;
        } else {
            this.varargsPosition = null;
        }
    }

    @Override
    public TypedValue execute(EvaluationContext context, Object ... arguments) throws AccessException {
        try {
            if (arguments != null) {
                ReflectionHelper.convertArguments(context.getTypeConverter(), arguments, this.ctor, this.varargsPosition);
            }
            if (this.ctor.isVarArgs()) {
                arguments = ReflectionHelper.setupArgumentsForVarargsInvocation(this.ctor.getParameterTypes(), arguments);
            }
            ReflectionUtils.makeAccessible(this.ctor);
            return new TypedValue(this.ctor.newInstance(arguments));
        }
        catch (Exception ex) {
            throw new AccessException("Problem invoking constructor: " + this.ctor, ex);
        }
    }

    public Constructor<?> getConstructor() {
        return this.ctor;
    }
}

