/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.evosuite.shaded.org.springframework.beans.factory.config.AbstractFactoryBean;
import org.evosuite.shaded.org.springframework.context.ResourceLoaderAware;
import org.evosuite.shaded.org.springframework.core.io.Resource;
import org.evosuite.shaded.org.springframework.core.io.ResourceLoader;
import org.evosuite.shaded.org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.evosuite.shaded.org.springframework.core.io.support.ResourcePatternResolver;
import org.evosuite.shaded.org.springframework.core.io.support.ResourcePatternUtils;

public class SortedResourcesFactoryBean
extends AbstractFactoryBean<Resource[]>
implements ResourceLoaderAware {
    private final List<String> locations;
    private ResourcePatternResolver resourcePatternResolver;

    public SortedResourcesFactoryBean(List<String> locations) {
        this.locations = locations;
        this.resourcePatternResolver = new PathMatchingResourcePatternResolver();
    }

    public SortedResourcesFactoryBean(ResourceLoader resourceLoader, List<String> locations) {
        this.locations = locations;
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver(resourceLoader);
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver(resourceLoader);
    }

    @Override
    public Class<? extends Resource[]> getObjectType() {
        return Resource[].class;
    }

    @Override
    protected Resource[] createInstance() throws Exception {
        ArrayList<Resource> scripts = new ArrayList<Resource>();
        for (String location : this.locations) {
            ArrayList<Resource> resources = new ArrayList<Resource>(Arrays.asList(this.resourcePatternResolver.getResources(location)));
            Collections.sort(resources, new Comparator<Resource>(){

                @Override
                public int compare(Resource r1, Resource r2) {
                    try {
                        return r1.getURL().toString().compareTo(r2.getURL().toString());
                    }
                    catch (IOException ex) {
                        return 0;
                    }
                }
            });
            for (Resource resource : resources) {
                scripts.add(resource);
            }
        }
        return scripts.toArray(new Resource[scripts.size()]);
    }
}

