/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.core.metadata;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.evosuite.shaded.org.springframework.jdbc.core.metadata.GenericTableMetaDataProvider;

public class PostgresTableMetaDataProvider
extends GenericTableMetaDataProvider {
    public PostgresTableMetaDataProvider(DatabaseMetaData databaseMetaData) throws SQLException {
        super(databaseMetaData);
    }

    @Override
    public boolean isGetGeneratedKeysSimulated() {
        if (this.getDatabaseVersion().compareTo("8.2.0") >= 0) {
            return true;
        }
        if (logger.isWarnEnabled()) {
            logger.warn("PostgreSQL does not support getGeneratedKeys or INSERT ... RETURNING in version " + this.getDatabaseVersion());
        }
        return false;
    }

    @Override
    public String getSimpleQueryForGetGeneratedKey(String tableName, String keyColumnName) {
        return "RETURNING " + keyColumnName;
    }
}

