/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.support;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLTransientException;
import org.evosuite.shaded.org.springframework.dao.ConcurrencyFailureException;
import org.evosuite.shaded.org.springframework.dao.DataAccessException;
import org.evosuite.shaded.org.springframework.dao.DataAccessResourceFailureException;
import org.evosuite.shaded.org.springframework.dao.DataIntegrityViolationException;
import org.evosuite.shaded.org.springframework.dao.InvalidDataAccessApiUsageException;
import org.evosuite.shaded.org.springframework.dao.PermissionDeniedDataAccessException;
import org.evosuite.shaded.org.springframework.dao.QueryTimeoutException;
import org.evosuite.shaded.org.springframework.dao.RecoverableDataAccessException;
import org.evosuite.shaded.org.springframework.dao.TransientDataAccessResourceException;
import org.evosuite.shaded.org.springframework.jdbc.BadSqlGrammarException;
import org.evosuite.shaded.org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator;
import org.evosuite.shaded.org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;

public class SQLExceptionSubclassTranslator
extends AbstractFallbackSQLExceptionTranslator {
    public SQLExceptionSubclassTranslator() {
        this.setFallbackTranslator(new SQLStateSQLExceptionTranslator());
    }

    @Override
    protected DataAccessException doTranslate(String task, String sql, SQLException ex) {
        if (ex instanceof SQLTransientException) {
            if (ex instanceof SQLTransientConnectionException) {
                return new TransientDataAccessResourceException(this.buildMessage(task, sql, ex), ex);
            }
            if (ex instanceof SQLTransactionRollbackException) {
                return new ConcurrencyFailureException(this.buildMessage(task, sql, ex), ex);
            }
            if (ex instanceof SQLTimeoutException) {
                return new QueryTimeoutException(this.buildMessage(task, sql, ex), ex);
            }
        } else if (ex instanceof SQLNonTransientException) {
            if (ex instanceof SQLNonTransientConnectionException) {
                return new DataAccessResourceFailureException(this.buildMessage(task, sql, ex), ex);
            }
            if (ex instanceof SQLDataException) {
                return new DataIntegrityViolationException(this.buildMessage(task, sql, ex), ex);
            }
            if (ex instanceof SQLIntegrityConstraintViolationException) {
                return new DataIntegrityViolationException(this.buildMessage(task, sql, ex), ex);
            }
            if (ex instanceof SQLInvalidAuthorizationSpecException) {
                return new PermissionDeniedDataAccessException(this.buildMessage(task, sql, ex), ex);
            }
            if (ex instanceof SQLSyntaxErrorException) {
                return new BadSqlGrammarException(task, sql, ex);
            }
            if (ex instanceof SQLFeatureNotSupportedException) {
                return new InvalidDataAccessApiUsageException(this.buildMessage(task, sql, ex), ex);
            }
        } else if (ex instanceof SQLRecoverableException) {
            return new RecoverableDataAccessException(this.buildMessage(task, sql, ex), ex);
        }
        return null;
    }
}

