/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.hibernate5;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.evosuite.shaded.org.hibernate.TransactionException;
import org.evosuite.shaded.org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.evosuite.shaded.org.springframework.transaction.jta.UserTransactionAdapter;
import org.evosuite.shaded.org.springframework.util.Assert;

class ConfigurableJtaPlatform
implements JtaPlatform {
    private final TransactionManager transactionManager;
    private final UserTransaction userTransaction;
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;

    public ConfigurableJtaPlatform(TransactionManager tm, UserTransaction ut, TransactionSynchronizationRegistry tsr) {
        Assert.notNull(tm, "TransactionManager reference must not be null");
        this.transactionManager = tm;
        this.userTransaction = ut != null ? ut : new UserTransactionAdapter(tm);
        this.transactionSynchronizationRegistry = tsr;
    }

    @Override
    public TransactionManager retrieveTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public UserTransaction retrieveUserTransaction() {
        return this.userTransaction;
    }

    @Override
    public Object getTransactionIdentifier(Transaction transaction) {
        return transaction;
    }

    @Override
    public boolean canRegisterSynchronization() {
        try {
            return this.transactionManager.getStatus() == 0;
        }
        catch (SystemException ex) {
            throw new TransactionException("Could not determine JTA transaction status", ex);
        }
    }

    @Override
    public void registerSynchronization(Synchronization synchronization) {
        if (this.transactionSynchronizationRegistry != null) {
            this.transactionSynchronizationRegistry.registerInterposedSynchronization(synchronization);
        } else {
            try {
                this.transactionManager.getTransaction().registerSynchronization(synchronization);
            }
            catch (Exception ex) {
                throw new TransactionException("Could not access JTA Transaction to register synchronization", ex);
            }
        }
    }

    @Override
    public int getCurrentStatus() throws SystemException {
        return this.transactionManager.getStatus();
    }
}

