/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.hibernate5;

import javax.persistence.PersistenceException;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.springframework.dao.DataAccessException;
import org.evosuite.shaded.org.springframework.dao.support.PersistenceExceptionTranslator;
import org.evosuite.shaded.org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.evosuite.shaded.org.springframework.orm.jpa.EntityManagerFactoryUtils;

public class HibernateExceptionTranslator
implements PersistenceExceptionTranslator {
    @Override
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof HibernateException) {
            return this.convertHibernateAccessException((HibernateException)ex);
        }
        if (ex instanceof PersistenceException) {
            if (ex.getCause() instanceof HibernateException) {
                return this.convertHibernateAccessException((HibernateException)ex.getCause());
            }
            return EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
        }
        return null;
    }

    protected DataAccessException convertHibernateAccessException(HibernateException ex) {
        return SessionFactoryUtils.convertHibernateAccessException(ex);
    }
}

