/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.jdo;

import java.sql.Connection;
import java.sql.SQLException;
import javax.jdo.JDOException;
import javax.jdo.PersistenceManager;
import javax.jdo.Transaction;
import org.evosuite.shaded.org.springframework.dao.DataAccessException;
import org.evosuite.shaded.org.springframework.dao.support.PersistenceExceptionTranslator;
import org.evosuite.shaded.org.springframework.jdbc.datasource.ConnectionHandle;
import org.evosuite.shaded.org.springframework.jdbc.support.JdbcUtils;
import org.evosuite.shaded.org.springframework.jdbc.support.SQLExceptionTranslator;
import org.evosuite.shaded.org.springframework.orm.jdo.JdoDialect;
import org.evosuite.shaded.org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.evosuite.shaded.org.springframework.transaction.TransactionDefinition;
import org.evosuite.shaded.org.springframework.transaction.TransactionException;

public class DefaultJdoDialect
implements JdoDialect,
PersistenceExceptionTranslator {
    private SQLExceptionTranslator jdbcExceptionTranslator;

    public DefaultJdoDialect() {
    }

    public DefaultJdoDialect(Object connectionFactory) {
        this.jdbcExceptionTranslator = PersistenceManagerFactoryUtils.newJdbcExceptionTranslator(connectionFactory);
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        return this.jdbcExceptionTranslator;
    }

    @Override
    public Object beginTransaction(Transaction transaction, TransactionDefinition definition) throws JDOException, SQLException, TransactionException {
        String jdoIsolationLevel = this.getJdoIsolationLevel(definition);
        if (jdoIsolationLevel != null) {
            transaction.setIsolationLevel(jdoIsolationLevel);
        }
        transaction.begin();
        return null;
    }

    protected String getJdoIsolationLevel(TransactionDefinition definition) {
        switch (definition.getIsolationLevel()) {
            case 8: {
                return "serializable";
            }
            case 4: {
                return "repeatable-read";
            }
            case 2: {
                return "read-committed";
            }
            case 1: {
                return "read-uncommitted";
            }
        }
        return null;
    }

    @Override
    public void cleanupTransaction(Object transactionData) {
    }

    @Override
    public ConnectionHandle getJdbcConnection(PersistenceManager pm, boolean readOnly) throws JDOException, SQLException {
        return new DataStoreConnectionHandle(pm);
    }

    @Override
    public void releaseJdbcConnection(ConnectionHandle conHandle, PersistenceManager pm) throws JDOException, SQLException {
    }

    @Override
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof JDOException) {
            return this.translateException((JDOException)ex);
        }
        return null;
    }

    @Override
    public DataAccessException translateException(JDOException ex) {
        if (this.getJdbcExceptionTranslator() != null && ex.getCause() instanceof SQLException) {
            return this.getJdbcExceptionTranslator().translate("JDO operation: " + ex.getMessage(), this.extractSqlStringFromException(ex), (SQLException)ex.getCause());
        }
        return PersistenceManagerFactoryUtils.convertJdoAccessException(ex);
    }

    protected String extractSqlStringFromException(JDOException ex) {
        return null;
    }

    private static class DataStoreConnectionHandle
    implements ConnectionHandle {
        private final PersistenceManager persistenceManager;

        public DataStoreConnectionHandle(PersistenceManager persistenceManager) {
            this.persistenceManager = persistenceManager;
        }

        @Override
        public Connection getConnection() {
            return (Connection)this.persistenceManager.getDataStoreConnection();
        }

        @Override
        public void releaseConnection(Connection con) {
            JdbcUtils.closeConnection(con);
        }
    }
}

