/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.evosuite.shaded.org.apache.commons.logging.Log;
import org.evosuite.shaded.org.apache.commons.logging.LogFactory;
import org.evosuite.shaded.org.springframework.core.BridgeMethodResolver;
import org.evosuite.shaded.org.springframework.core.MethodClassKey;
import org.evosuite.shaded.org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.evosuite.shaded.org.springframework.transaction.interceptor.TransactionAttribute;
import org.evosuite.shaded.org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.evosuite.shaded.org.springframework.util.ClassUtils;

public abstract class AbstractFallbackTransactionAttributeSource
implements TransactionAttributeSource {
    private static final TransactionAttribute NULL_TRANSACTION_ATTRIBUTE = new DefaultTransactionAttribute();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<Object, TransactionAttribute> attributeCache = new ConcurrentHashMap<Object, TransactionAttribute>(1024);

    @Override
    public TransactionAttribute getTransactionAttribute(Method method, Class<?> targetClass) {
        if (method.getDeclaringClass() == Object.class) {
            return null;
        }
        Object cacheKey = this.getCacheKey(method, targetClass);
        TransactionAttribute cached = this.attributeCache.get(cacheKey);
        if (cached != null) {
            if (cached == NULL_TRANSACTION_ATTRIBUTE) {
                return null;
            }
            return cached;
        }
        TransactionAttribute txAttr = this.computeTransactionAttribute(method, targetClass);
        if (txAttr == null) {
            this.attributeCache.put(cacheKey, NULL_TRANSACTION_ATTRIBUTE);
        } else {
            String methodIdentification = ClassUtils.getQualifiedMethodName(method, targetClass);
            if (txAttr instanceof DefaultTransactionAttribute) {
                ((DefaultTransactionAttribute)txAttr).setDescriptor(methodIdentification);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Adding transactional method '" + methodIdentification + "' with attribute: " + txAttr);
            }
            this.attributeCache.put(cacheKey, txAttr);
        }
        return txAttr;
    }

    protected Object getCacheKey(Method method, Class<?> targetClass) {
        return new MethodClassKey(method, targetClass);
    }

    protected TransactionAttribute computeTransactionAttribute(Method method, Class<?> targetClass) {
        if (this.allowPublicMethodsOnly() && !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?> userClass = ClassUtils.getUserClass(targetClass);
        Method specificMethod = ClassUtils.getMostSpecificMethod(method, userClass);
        TransactionAttribute txAttr = this.findTransactionAttribute(specificMethod = BridgeMethodResolver.findBridgedMethod(specificMethod));
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = this.findTransactionAttribute(specificMethod.getDeclaringClass());
        if (txAttr != null && ClassUtils.isUserLevelMethod(method)) {
            return txAttr;
        }
        if (specificMethod != method) {
            txAttr = this.findTransactionAttribute(method);
            if (txAttr != null) {
                return txAttr;
            }
            txAttr = this.findTransactionAttribute(method.getDeclaringClass());
            if (txAttr != null && ClassUtils.isUserLevelMethod(method)) {
                return txAttr;
            }
        }
        return null;
    }

    protected abstract TransactionAttribute findTransactionAttribute(Method var1);

    protected abstract TransactionAttribute findTransactionAttribute(Class<?> var1);

    protected boolean allowPublicMethodsOnly() {
        return false;
    }
}

