/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.strategy;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.CoverageCriteriaAnalyzer;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.coverage.branch.BranchCoverageSuiteFitness;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.ga.stoppingconditions.StoppingCondition;
import org.evosuite.ga.stoppingconditions.ZeroFitnessStoppingCondition;
import org.evosuite.junit.JUnitAnalyzer;
import org.evosuite.regression.RegressionAssertionCounter;
import org.evosuite.regression.RegressionMeasure;
import org.evosuite.regression.RegressionTestChromosome;
import org.evosuite.regression.RegressionTestChromosomeFactory;
import org.evosuite.regression.RegressionTestSuiteChromosome;
import org.evosuite.result.TestGenerationResultBuilder;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.strategy.PropertiesSuiteGAFactory;
import org.evosuite.strategy.TestGenerationStrategy;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;

public class RegressionSuiteStrategy
extends TestGenerationStrategy {
    public static final ZeroFitnessStoppingCondition zero_fitness = new ZeroFitnessStoppingCondition();

    @Override
    public TestSuiteChromosome generateTests() {
        this.track(RuntimeVariable.Total_Goals, 0);
        this.track(RuntimeVariable.Generated_Assertions, 0);
        this.track(RuntimeVariable.Coverage_Old, 0);
        this.track(RuntimeVariable.Coverage_New, 0);
        this.track(RuntimeVariable.Exception_Difference, 0);
        this.track(RuntimeVariable.State_Distance, 0);
        this.track(RuntimeVariable.Testsuite_Diversity, 0);
        Properties.TEST_ARCHIVE = false;
        Properties.P_FUNCTIONAL_MOCKING = 0.0;
        Properties.FUNCTIONAL_MOCKING_INPUT_LIMIT = 0;
        Properties.FUNCTIONAL_MOCKING_PERCENT = 0.0;
        if (Properties.REGRESSION_FITNESS == RegressionMeasure.RANDOM) {
            return this.generateRandomRegressionTests();
        }
        LoggingUtils.getEvoLogger().info("* Setting up search algorithm for REGRESSION suite generation");
        PropertiesSuiteGAFactory algorithmFactory = new PropertiesSuiteGAFactory();
        GeneticAlgorithm<TestSuiteChromosome> algorithm = algorithmFactory.getSearchAlgorithm();
        if (Properties.SERIALIZE_GA || Properties.CLIENT_ON_THREAD) {
            TestGenerationResultBuilder.getInstance().setGeneticAlgorithm(algorithm);
        }
        long startTime = System.currentTimeMillis() / 1000L;
        Properties.CRITERION = new Properties.Criterion[]{Properties.Criterion.REGRESSION};
        List fitnessFunctions = this.getFitnessFunctions();
        algorithm.addFitnessFunctions(fitnessFunctions);
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.ALLDEFS) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.STATEMENT) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.RHO) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.AMBIGUITY)) {
            ExecutionTracer.enableTraceCalls();
        }
        algorithm.resetStoppingConditions();
        List<TestFitnessFunction> goals = this.getGoals(true);
        TestSuiteChromosome bestSuites = new TestSuiteChromosome();
        RegressionTestSuiteChromosome best = null;
        if (!Properties.STOP_ZERO || !goals.isEmpty()) {
            LoggingUtils.getEvoLogger().info("* Using seed {}", (Object)Randomness.getSeed());
            LoggingUtils.getEvoLogger().info("* Starting evolution");
            ClientServices.getInstance().getClientNode().changeState(ClientState.SEARCH);
            algorithm.generateSolution();
            best = (RegressionTestSuiteChromosome)algorithm.getBestIndividual();
            for (TestCase t : best.getTests()) {
                bestSuites.addTest(t);
            }
            if (bestSuites.size() == 0) {
                LoggingUtils.getEvoLogger().warn("Could not find any suiteable chromosome");
                return bestSuites;
            }
        } else {
            this.zeroFitness.setFinished();
            bestSuites = new TestSuiteChromosome();
            for (FitnessFunction<?> ff : bestSuites.getFitnessValues().keySet()) {
                bestSuites.setCoverage(ff, 1.0);
            }
        }
        long end_time = System.currentTimeMillis() / 1000L;
        goals = this.getGoals(false);
        this.track(RuntimeVariable.Total_Goals, goals.size());
        if (Properties.SHOW_PROGRESS) {
            LoggingUtils.getEvoLogger().info("");
        }
        String text = " statements, best individual has fitness: ";
        if (bestSuites.size() > 1) {
            text = " statements, best individuals have fitness: ";
        }
        LoggingUtils.getEvoLogger().info("* Search finished after " + (end_time - startTime) + "s and " + algorithm.getAge() + " generations, " + MaxStatementsStoppingCondition.getNumExecutedStatements() + text + (best != null ? Double.valueOf(best.getFitness()) : ""));
        if (Properties.COVERAGE) {
            for (Properties.Criterion pc : Properties.CRITERION) {
                CoverageCriteriaAnalyzer.analyzeCoverage(bestSuites, pc);
            }
        }
        int number_of_test_cases = 0;
        int totalLengthOfTestCases = 0;
        double coverage = 0.0;
        number_of_test_cases += bestSuites.size();
        totalLengthOfTestCases += bestSuites.totalLengthOfTestCases();
        coverage += bestSuites.getCoverage();
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.MUTATION) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.STRONGMUTATION)) {
            // empty if block
        }
        LoggingUtils.getEvoLogger().info("* Generated " + number_of_test_cases + " tests with total length " + totalLengthOfTestCases);
        if (!Properties.ANALYSIS_CRITERIA.isEmpty()) {
            CoverageCriteriaAnalyzer.analyzeCriteria(bestSuites, Properties.ANALYSIS_CRITERIA);
        }
        LoggingUtils.getEvoLogger().info("* Resulting test suite's coverage: " + NumberFormat.getPercentInstance().format(coverage));
        algorithm.printBudget();
        return bestSuites;
    }

    private TestSuiteChromosome generateRandomRegressionTests() {
        LoggingUtils.getEvoLogger().info("* Using RANDOM regression test generation");
        if (Properties.KEEP_REGRESSION_ARCHIVE) {
            Properties.TEST_ARCHIVE = true;
        }
        RegressionTestSuiteChromosome suite = new RegressionTestSuiteChromosome();
        PropertiesSuiteGAFactory algorithmFactory = new PropertiesSuiteGAFactory();
        GeneticAlgorithm<TestSuiteChromosome> suiteGA = algorithmFactory.getSearchAlgorithm();
        BranchCoverageSuiteFitness branchCoverageSuiteFitness = new BranchCoverageSuiteFitness(TestGenerationContext.getInstance().getClassLoaderForSUT());
        RegressionTestChromosomeFactory factory = new RegressionTestChromosomeFactory();
        LoggingUtils.getEvoLogger().warn("*** generating RANDOM regression tests");
        List<TestFitnessFunction> goals = this.getGoals(true);
        this.track(RuntimeVariable.Total_Goals, goals.size());
        StoppingCondition stoppingCondition = this.getStoppingCondition();
        int totalTestCount = 0;
        int usefulTestCount = 0;
        int simulatedAge = 0;
        int numAssertions = 0;
        int executedStatemets = 0;
        boolean firstTry = true;
        long startTime = System.currentTimeMillis();
        while (!stoppingCondition.isFinished() || numAssertions != 0) {
            if (numAssertions == 0 || Properties.REGRESSION_RANDOM_STRATEGY == 1 || Properties.REGRESSION_RANDOM_STRATEGY == 2) {
                RegressionTestChromosome test = factory.getChromosome();
                RegressionTestSuiteChromosome clone = new RegressionTestSuiteChromosome();
                clone.addTest(test);
                List<TestCase> testCases = clone.getTests();
                executedStatemets += test.size();
                numAssertions = RegressionAssertionCounter.getNumAssertions(clone);
                if (Properties.KEEP_REGRESSION_ARCHIVE) {
                    branchCoverageSuiteFitness.getFitness(clone.getTestSuite());
                }
                if (numAssertions > 0) {
                    LoggingUtils.getEvoLogger().warn("Generated test with {} assertions.", (Object)numAssertions);
                }
                ++totalTestCount;
                if (numAssertions > 0) {
                    numAssertions = 0;
                    JUnitAnalyzer.removeTestsThatDoNotCompile(testCases);
                    JUnitAnalyzer.handleTestsThatAreUnstable(testCases);
                    if (testCases.size() > 0) {
                        clone = new RegressionTestSuiteChromosome();
                        for (TestCase t : testCases) {
                            RegressionTestChromosome rtc = new RegressionTestChromosome();
                            if (t.isUnstable()) continue;
                            TestChromosome tc = new TestChromosome();
                            tc.setTestCase(t);
                            rtc.setTest(tc);
                            clone.addTest(rtc);
                        }
                        numAssertions = RegressionAssertionCounter.getNumAssertions(clone, false, false);
                        LoggingUtils.getEvoLogger().warn("Keeping {} assertions.", (Object)numAssertions);
                        if (numAssertions > 0) {
                            ++usefulTestCount;
                            suite.addTest(test);
                        }
                    } else {
                        LoggingUtils.getEvoLogger().warn("ignored assertions. tests were removed.");
                    }
                }
            } else if (numAssertions > 0) break;
            if (!firstTry && System.currentTimeMillis() - startTime < 4000L) continue;
            startTime = System.currentTimeMillis();
            ++simulatedAge;
            firstTry = false;
        }
        LoggingUtils.getEvoLogger().warn("*** Random test generation finished.");
        LoggingUtils.getEvoLogger().warn("*=*=*=* Total tests: {} | Tests with assertion: {}", (Object)totalTestCount, (Object)usefulTestCount);
        zero_fitness.setFinished();
        LoggingUtils.getEvoLogger().info("* Generated " + suite.size() + " tests with total length " + suite.totalLengthOfTestCases());
        goals = this.getGoals(false);
        this.track(RuntimeVariable.Total_Goals, goals.size());
        suiteGA.printBudget();
        if (Properties.REGRESSION_RANDOM_STRATEGY != 2 && Properties.REGRESSION_RANDOM_STRATEGY != 3) {
            suite = new RegressionTestSuiteChromosome();
        }
        TestSuiteChromosome bestSuites = new TestSuiteChromosome();
        for (TestCase t : suite.getTests()) {
            bestSuites.addTest(t);
        }
        return bestSuites;
    }

    private List<TestFitnessFunction> getGoals(boolean verbose) {
        List<TestFitnessFactory<? extends TestFitnessFunction>> goalFactories = RegressionSuiteStrategy.getFitnessFactories();
        ArrayList<TestFitnessFunction> goals = new ArrayList<TestFitnessFunction>();
        if (goalFactories.size() == 1) {
            TestFitnessFactory<? extends TestFitnessFunction> factory = goalFactories.iterator().next();
            goals.addAll(factory.getCoverageGoals());
            if (verbose) {
                LoggingUtils.getEvoLogger().info("* Total number of test goals: {}", (Object)factory.getCoverageGoals().size());
            }
        } else {
            if (verbose) {
                LoggingUtils.getEvoLogger().info("* Total number of test goals: ");
            }
            for (TestFitnessFactory<? extends TestFitnessFunction> goalFactory : goalFactories) {
                goals.addAll(goalFactory.getCoverageGoals());
                if (!verbose) continue;
                LoggingUtils.getEvoLogger().info("  - " + goalFactory.getClass().getSimpleName().replace("CoverageFactory", "") + " " + goalFactory.getCoverageGoals().size());
            }
        }
        return goals;
    }

    private void track(RuntimeVariable variable, Object value) {
        ClientServices.getInstance().getClientNode().trackOutputVariable(variable, value);
    }
}

