/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.strategy;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.ProgressMonitor;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.FitnessFunctions;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.ga.stoppingconditions.GlobalTimeStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxFitnessEvaluationsStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxGenerationStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxTestsStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxTimeStoppingCondition;
import org.evosuite.ga.stoppingconditions.StoppingCondition;
import org.evosuite.ga.stoppingconditions.ZeroFitnessStoppingCondition;
import org.evosuite.graphs.cfg.CFGMethodAdapter;
import org.evosuite.rmi.ClientServices;
import org.evosuite.setup.TestCluster;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.utils.LoggingUtils;

public abstract class TestGenerationStrategy {
    protected final ProgressMonitor progressMonitor = new ProgressMonitor();
    protected ZeroFitnessStoppingCondition zeroFitness = new ZeroFitnessStoppingCondition();
    protected StoppingCondition globalTime = new GlobalTimeStoppingCondition();

    public abstract TestSuiteChromosome generateTests();

    protected void sendExecutionStatistics() {
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Statements_Executed, MaxStatementsStoppingCondition.getNumExecutedStatements());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Tests_Executed, MaxTestsStoppingCondition.getNumExecutedTests());
    }

    protected List<TestSuiteFitnessFunction> getFitnessFunctions() {
        ArrayList<TestSuiteFitnessFunction> ffs = new ArrayList<TestSuiteFitnessFunction>();
        for (int i = 0; i < Properties.CRITERION.length; ++i) {
            TestSuiteFitnessFunction newFunction = FitnessFunctions.getFitnessFunction(Properties.CRITERION[i]);
            if (Properties.ALGORITHM != Properties.Algorithm.NSGAII && Properties.ALGORITHM != Properties.Algorithm.SPEA2) {
                for (TestSuiteFitnessFunction oldFunction : ffs) {
                    if (oldFunction.isMaximizationFunction() == newFunction.isMaximizationFunction()) continue;
                    StringBuffer sb = new StringBuffer();
                    sb.append("* Invalid combination of fitness functions: ");
                    sb.append(oldFunction.toString());
                    if (oldFunction.isMaximizationFunction()) {
                        sb.append(" is a maximization function ");
                    } else {
                        sb.append(" is a minimization function ");
                    }
                    sb.append(" but ");
                    sb.append(newFunction.toString());
                    if (newFunction.isMaximizationFunction()) {
                        sb.append(" is a maximization function ");
                    } else {
                        sb.append(" is a minimization function ");
                    }
                    LoggingUtils.getEvoLogger().info(sb.toString());
                    throw new RuntimeException("Invalid combination of fitness functions");
                }
            }
            ffs.add(newFunction);
        }
        return ffs;
    }

    public static List<TestFitnessFactory<? extends TestFitnessFunction>> getFitnessFactories() {
        ArrayList<TestFitnessFactory<? extends TestFitnessFunction>> goalsFactory = new ArrayList<TestFitnessFactory<? extends TestFitnessFunction>>();
        for (int i = 0; i < Properties.CRITERION.length; ++i) {
            goalsFactory.add(FitnessFunctions.getFitnessFactory(Properties.CRITERION[i]));
        }
        return goalsFactory;
    }

    protected boolean isFinished(TestSuiteChromosome chromosome, StoppingCondition stoppingCondition) {
        if (stoppingCondition.isFinished()) {
            return true;
        }
        if (Properties.STOP_ZERO && chromosome.getFitness() == 0.0) {
            return true;
        }
        return !(stoppingCondition instanceof MaxTimeStoppingCondition) && this.globalTime.isFinished();
    }

    protected StoppingCondition getStoppingCondition() {
        switch (Properties.STOPPING_CONDITION) {
            case MAXGENERATIONS: {
                return new MaxGenerationStoppingCondition();
            }
            case MAXFITNESSEVALUATIONS: {
                return new MaxFitnessEvaluationsStoppingCondition();
            }
            case MAXTIME: {
                return new MaxTimeStoppingCondition();
            }
            case MAXTESTS: {
                return new MaxTestsStoppingCondition();
            }
            case MAXSTATEMENTS: {
                return new MaxStatementsStoppingCondition();
            }
        }
        return new MaxGenerationStoppingCondition();
    }

    protected boolean canGenerateTestsForSUT() {
        return TestCluster.getInstance().getNumTestCalls() != 0 || !(Properties.P_REFLECTION_ON_PRIVATE <= 0.0) && CFGMethodAdapter.getNumMethods(TestGenerationContext.getInstance().getClassLoaderForSUT()) != 0;
    }
}

