/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.symbolic.BranchCondition;
import org.evosuite.symbolic.expr.BinaryExpression;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.UnaryExpression;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.solver.Solver;
import org.evosuite.symbolic.solver.SolverCache;
import org.evosuite.symbolic.solver.SolverFactory;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.numeric.BooleanPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.BytePrimitiveStatement;
import org.evosuite.testcase.statements.numeric.CharPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.IntPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.LongPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.NumericalPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.ShortPrimitiveStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcolicMutation {
    protected static final Logger logger = LoggerFactory.getLogger(ConcolicMutation.class);

    public static TestCase negateCondition(List<BranchCondition> pathCondition, BranchCondition targetCondition, TestCase test) {
        List<Constraint<?>> constraints = new LinkedList();
        for (BranchCondition b : pathCondition) {
            constraints.addAll(b.getSupportingConstraints());
            if (b == targetCondition) break;
            constraints.add(b.getConstraint());
        }
        Constraint<?> targetConstraint = targetCondition.getConstraint().negate();
        constraints.add(targetConstraint);
        if (!targetConstraint.isSolveable()) {
            logger.info("Found unsolvable constraint: " + targetConstraint);
            return null;
        }
        int size = constraints.size();
        if (size > 0) {
            constraints = ConcolicMutation.reduce(constraints);
        }
        Solver solver = SolverFactory.getInstance().buildNewSolver();
        SolverCache solverCache = SolverCache.getInstance();
        SolverResult solverResult = solverCache.solve(solver, constraints);
        if (solverResult != null) {
            TestCase newTest = test.clone();
            Map<String, Object> model = solverResult.getModel();
            for (String key : model.keySet()) {
                Object val = model.get(key);
                if (val != null) {
                    if (val instanceof Long) {
                        NumericalPrimitiveStatement bp;
                        Long value = (Long)val;
                        String name = key.replace("__SYM", "");
                        logger.debug("New value for " + name + " is " + value);
                        PrimitiveStatement<?> p = ConcolicMutation.getStatement(newTest, name);
                        assert (p != null);
                        if (p instanceof BooleanPrimitiveStatement) {
                            bp = (BooleanPrimitiveStatement)p;
                            bp.setValue(value.intValue() > 0);
                            continue;
                        }
                        if (p instanceof CharPrimitiveStatement) {
                            CharPrimitiveStatement cp = (CharPrimitiveStatement)p;
                            cp.setValue(Character.valueOf((char)value.intValue()));
                            continue;
                        }
                        if (p instanceof BytePrimitiveStatement) {
                            bp = (BytePrimitiveStatement)p;
                            bp.setValue((byte)value.intValue());
                            continue;
                        }
                        if (p instanceof ShortPrimitiveStatement) {
                            ShortPrimitiveStatement sp = (ShortPrimitiveStatement)p;
                            sp.setValue((short)value.intValue());
                            continue;
                        }
                        if (p instanceof LongPrimitiveStatement) {
                            LongPrimitiveStatement lp = (LongPrimitiveStatement)p;
                            lp.setValue(value);
                            continue;
                        }
                        assert (p instanceof IntPrimitiveStatement);
                        IntPrimitiveStatement ip = (IntPrimitiveStatement)p;
                        ip.setValue(value.intValue());
                        continue;
                    }
                    logger.debug("New value is not long " + val);
                    continue;
                }
                logger.debug("New value is null");
            }
            return newTest;
        }
        logger.debug("Got null :-(");
        return null;
    }

    private static PrimitiveStatement<?> getStatement(TestCase test, String name) {
        for (Statement statement : test) {
            if (!(statement instanceof PrimitiveStatement) || !statement.getReturnValue().getName().equals(name)) continue;
            return (PrimitiveStatement)statement;
        }
        return null;
    }

    private static List<Constraint<?>> reduce(List<Constraint<?>> constraints) {
        Constraint<?> target = constraints.get(constraints.size() - 1);
        Set<Variable<?>> dependencies = ConcolicMutation.getVariables(target);
        LinkedList coi = new LinkedList();
        coi.add(target);
        block0: for (int i = constraints.size() - 2; i >= 0; --i) {
            Constraint<?> constraint = constraints.get(i);
            Set<Variable<?>> variables = ConcolicMutation.getVariables(constraint);
            for (Variable<?> var : dependencies) {
                if (!variables.contains(var)) continue;
                dependencies.addAll(variables);
                coi.addFirst(constraint);
                continue block0;
            }
        }
        return coi;
    }

    private static Set<Variable<?>> getVariables(Constraint<?> constraint) {
        HashSet variables = new HashSet();
        ConcolicMutation.getVariables(constraint.getLeftOperand(), variables);
        ConcolicMutation.getVariables(constraint.getRightOperand(), variables);
        return variables;
    }

    private static void getVariables(Expression<?> expr, Set<Variable<?>> variables) {
        if (expr instanceof Variable) {
            variables.add((Variable)expr);
        } else if (expr instanceof BinaryExpression) {
            BinaryExpression bin = (BinaryExpression)((Object)expr);
            ConcolicMutation.getVariables(bin.getLeftOperand(), variables);
            ConcolicMutation.getVariables(bin.getRightOperand(), variables);
        } else if (expr instanceof UnaryExpression) {
            UnaryExpression un = (UnaryExpression)((Object)expr);
            ConcolicMutation.getVariables(un.getOperand(), variables);
        } else if (expr instanceof Constraint) {
            // empty if block
        }
    }
}

