/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr.ref;

import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.symbolic.expr.AbstractExpression;
import org.evosuite.symbolic.expr.SymbolicValue;

public abstract class ReferenceExpression
extends AbstractExpression<Object>
implements SymbolicValue {
    private static final long serialVersionUID = 7925438069540850557L;
    private final int instanceId;
    private final Type objectType;
    private int concIdentityHashCode;
    private boolean isInitialized = false;

    public ReferenceExpression(Type objectType, int instanceId, int expressionSize, boolean containsSymbolicVariable) {
        super(null, expressionSize, containsSymbolicVariable);
        this.objectType = objectType;
        this.instanceId = instanceId;
        this.isInitialized = false;
        this.concIdentityHashCode = -1;
    }

    public void initializeReference(Object conc_object) {
        if (this.isInitialized) {
            throw new IllegalStateException("Reference already initialized!");
        }
        this.concreteValue = conc_object;
        this.concIdentityHashCode = System.identityHashCode(conc_object);
        this.isInitialized = true;
    }

    public String toString() {
        return this.getClassName() + "$" + this.instanceId;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public int getConcIdentityHashCode() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Object has to be initialized==true for this method to be invoked");
        }
        return this.concIdentityHashCode;
    }

    public String getClassName() {
        return this.objectType.getClassName();
    }

    public boolean isString() {
        Type stringType = Type.getType(String.class);
        return this.objectType.equals(stringType);
    }
}

