/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr.str;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.symbolic.expr.AbstractExpression;
import org.evosuite.symbolic.expr.ExpressionVisitor;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.str.StringValue;

public final class StringVariable
extends AbstractExpression<String>
implements StringValue,
Variable<String> {
    private static final long serialVersionUID = 5925030390824261492L;
    private final String name;
    private String maxValue;

    public StringVariable(String name, String concVal) {
        super(concVal, 1, true);
        this.name = name;
        this.maxValue = concVal;
    }

    public void setConcreteValue(String concValue) {
        this.concreteValue = concValue;
    }

    @Override
    public String getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    private String removeNonAsciiPrintable(String string) {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char charAt = string.charAt(i);
            if (!StringVariable.isAsciiPrintable(charAt)) continue;
            bf.append(charAt);
        }
        return bf.toString();
    }

    public String toString() {
        String asciiPrintableString = this.removeNonAsciiPrintable((String)this.concreteValue);
        return this.name + "(\"" + asciiPrintableString.replace("\n", "").replace(" ", "") + "\")";
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof StringVariable) {
            StringVariable v = (StringVariable)obj;
            return this.getName().equals(v.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public Set<Variable<?>> getVariables() {
        HashSet variables = new HashSet();
        variables.add(this);
        return variables;
    }

    @Override
    public Set<Object> getConstants() {
        return new HashSet<Object>();
    }

    @Override
    public String getMinValue() {
        return (String)this.concreteValue;
    }

    @Override
    public <K, V> K accept(ExpressionVisitor<K, V> v, V arg) {
        return v.visit(this, arg);
    }
}

