/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.solver.Solver;
import org.evosuite.symbolic.solver.SolverEmptyQueryException;
import org.evosuite.symbolic.solver.SolverErrorException;
import org.evosuite.symbolic.solver.SolverParseException;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.symbolic.solver.SolverTimeoutException;

public final class SolverCache {
    private static final SolverCache instance = new SolverCache();
    private HashMap<Collection<Constraint<?>>, SolverResult> cached_solver_results = new HashMap();
    private int cached_sat_result_count = 0;
    private int cached_unsat_result_count = 0;
    private int number_of_accesses = 0;
    private int number_of_hits = 0;
    private boolean valid_cached_solution = false;
    private SolverResult cached_solution = null;

    public SolverResult solve(Solver solver, Collection<Constraint<?>> constraints) {
        SolverResult solverResult;
        if (this.hasCachedResult(constraints)) {
            SolverResult cached_solution = this.getCachedResult();
            return cached_solution;
        }
        try {
            solverResult = solver.solve(constraints);
            if (solverResult.isUNSAT()) {
                this.addUNSAT(constraints, solverResult);
            } else {
                this.addSAT(constraints, solverResult);
            }
        }
        catch (IOException | SolverEmptyQueryException | SolverErrorException | SolverParseException | SolverTimeoutException e) {
            solverResult = null;
        }
        return solverResult;
    }

    public int getNumberOfUNSATs() {
        return this.cached_unsat_result_count;
    }

    public int getNumberOfSATs() {
        return this.cached_sat_result_count;
    }

    private SolverCache() {
    }

    public static SolverCache getInstance() {
        return instance;
    }

    private void addUNSAT(Collection<Constraint<?>> unsat_constraints, SolverResult unsatResult) {
        this.cached_solver_results.put(unsat_constraints, unsatResult);
        ++this.cached_unsat_result_count;
    }

    private void addSAT(Collection<Constraint<?>> sat_constraints, SolverResult satResult) {
        this.cached_solver_results.put(sat_constraints, satResult);
        ++this.cached_sat_result_count;
    }

    private boolean hasCachedResult(Collection<Constraint<?>> constraints) {
        ++this.number_of_accesses;
        if (this.cached_solver_results.containsKey(constraints)) {
            this.valid_cached_solution = true;
            this.cached_solution = this.cached_solver_results.get(constraints);
            ++this.number_of_hits;
            return true;
        }
        this.valid_cached_solution = false;
        return false;
    }

    public double getHitRate() {
        return (double)this.number_of_hits / (double)this.number_of_accesses;
    }

    public SolverResult getCachedResult() {
        if (!this.valid_cached_solution) {
            throw new IllegalArgumentException("The constraint is not cached!");
        }
        this.valid_cached_solution = false;
        return this.cached_solution;
    }
}

