/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.bv.IntegerBinaryExpression;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.evosuite.symbolic.expr.fp.RealBinaryExpression;
import org.evosuite.symbolic.expr.fp.RealConstant;
import org.evosuite.symbolic.expr.fp.RealValue;
import org.evosuite.symbolic.expr.ref.ReferenceConstant;
import org.evosuite.symbolic.expr.str.StringConstant;

public abstract class ExpressionFactory {
    public static final RealConstant RCONST_2 = new RealConstant(2.0);
    public static final RealConstant RCONST_1 = new RealConstant(1.0);
    public static final RealConstant RCONST_0 = new RealConstant(0.0);
    public static final IntegerConstant ICONST_5 = new IntegerConstant(5L);
    public static final IntegerConstant ICONST_4 = new IntegerConstant(4L);
    public static final IntegerConstant ICONST_3 = new IntegerConstant(3L);
    public static final IntegerConstant ICONST_2 = new IntegerConstant(2L);
    public static final IntegerConstant ICONST_1 = new IntegerConstant(1L);
    public static final IntegerConstant ICONST_0 = new IntegerConstant(0L);
    public static final IntegerConstant ICONST_M1 = new IntegerConstant(-1L);

    public static IntegerConstant buildNewIntegerConstant(int value) {
        return ExpressionFactory.buildNewIntegerConstant((long)value);
    }

    public static IntegerConstant buildNewIntegerConstant(long value) {
        if (value == -1L) {
            return ICONST_M1;
        }
        if (value == 0L) {
            return ICONST_0;
        }
        if (value == 1L) {
            return ICONST_1;
        }
        if (value == 2L) {
            return ICONST_2;
        }
        if (value == 3L) {
            return ICONST_3;
        }
        if (value == 4L) {
            return ICONST_4;
        }
        if (value == 5L) {
            return ICONST_5;
        }
        return new IntegerConstant(value);
    }

    public static RealConstant buildNewRealConstant(float x) {
        return ExpressionFactory.buildNewRealConstant((double)x);
    }

    public static RealConstant buildNewRealConstant(double x) {
        if (x == 0.0) {
            return RCONST_0;
        }
        if (x == 1.0) {
            return RCONST_1;
        }
        if (x == 2.0) {
            return RCONST_2;
        }
        return new RealConstant(x);
    }

    public static StringConstant buildNewStringConstant(String string) {
        return new StringConstant(string.intern());
    }

    public static IntegerValue add(IntegerValue left, IntegerValue right, long con) {
        if (!(left instanceof IntegerConstant) && right instanceof IntegerConstant) {
            return ExpressionFactory.buildAddNormalized(right, left, con);
        }
        return ExpressionFactory.buildAddNormalized(left, right, con);
    }

    private static IntegerValue buildAddNormalized(IntegerValue left, IntegerValue right, long con) {
        IntegerBinaryExpression add;
        if (!(left instanceof IntegerConstant)) {
            return new IntegerBinaryExpression(left, Operator.PLUS, right, con);
        }
        if ((Long)((IntegerConstant)left).getConcreteValue() == 0L) {
            return right;
        }
        if (right instanceof IntegerConstant) {
            long a = (Long)left.getConcreteValue();
            long b = (Long)right.getConcreteValue();
            return ExpressionFactory.buildNewIntegerConstant(a + b);
        }
        if (right instanceof IntegerBinaryExpression && ((IntegerBinaryExpression)right).getOperator() == Operator.PLUS && (add = (IntegerBinaryExpression)right).getLeftOperand() instanceof IntegerConstant) {
            long a = (Long)left.getConcreteValue();
            long b = add.getLeftOperand().getConcreteValue();
            IntegerConstant a_plus_b = ExpressionFactory.buildNewIntegerConstant(a + b);
            return new IntegerBinaryExpression(a_plus_b, Operator.PLUS, add.getRightOperand(), con);
        }
        return new IntegerBinaryExpression(left, Operator.PLUS, right, con);
    }

    public static RealValue add(RealValue left, RealValue right, double con) {
        if (!(left instanceof RealConstant) && right instanceof RealConstant) {
            return ExpressionFactory.buildAddNormalized(right, left, con);
        }
        return ExpressionFactory.buildAddNormalized(left, right, con);
    }

    private static RealValue buildAddNormalized(RealValue right, RealValue left, double con) {
        RealBinaryExpression add;
        if (!(left instanceof RealConstant)) {
            return new RealBinaryExpression(left, Operator.PLUS, right, con);
        }
        if ((Double)((RealConstant)left).getConcreteValue() == 0.0) {
            return right;
        }
        if (right instanceof RealConstant) {
            double a = (Double)left.getConcreteValue();
            double b = (Double)right.getConcreteValue();
            return ExpressionFactory.buildNewRealConstant(a + b);
        }
        if (right instanceof RealBinaryExpression && ((RealBinaryExpression)right).getOperator() == Operator.PLUS && (add = (RealBinaryExpression)right).getLeftOperand() instanceof RealConstant) {
            double a = (Double)left.getConcreteValue();
            double b = add.getLeftOperand().getConcreteValue();
            RealConstant a_plus_b = ExpressionFactory.buildNewRealConstant(a + b);
            return new RealBinaryExpression(a_plus_b, Operator.PLUS, add.getRightOperand(), con);
        }
        return new RealBinaryExpression(left, Operator.PLUS, right, con);
    }

    public static IntegerValue mul(IntegerValue left, IntegerValue right, long con) {
        if (!(left instanceof IntegerConstant) && right instanceof IntegerConstant) {
            return ExpressionFactory.buildMulNormalized(right, left, con);
        }
        return ExpressionFactory.buildMulNormalized(left, right, con);
    }

    private static IntegerValue buildMulNormalized(IntegerValue right, IntegerValue left, long con) {
        if (left instanceof IntegerConstant && (Long)left.getConcreteValue() == 0L) {
            return ExpressionFactory.buildNewIntegerConstant(0);
        }
        if (left instanceof IntegerConstant && (Long)left.getConcreteValue() == 1L) {
            return right;
        }
        if (left instanceof IntegerConstant && right instanceof IntegerConstant) {
            long a = (Long)left.getConcreteValue();
            long b = (Long)right.getConcreteValue();
            return ExpressionFactory.buildNewIntegerConstant(a * b);
        }
        return new IntegerBinaryExpression(left, Operator.MUL, right, con);
    }

    public static RealValue mul(RealValue left, RealValue right, double con) {
        if (!(left instanceof RealConstant) && right instanceof RealConstant) {
            return ExpressionFactory.buildMulNormalized(right, left, con);
        }
        return ExpressionFactory.buildMulNormalized(left, right, con);
    }

    private static RealValue buildMulNormalized(RealValue right, RealValue left, double con) {
        if (left instanceof RealConstant && (Double)left.getConcreteValue() == 0.0) {
            return ExpressionFactory.buildNewRealConstant(0.0);
        }
        if (left instanceof RealConstant && (Double)left.getConcreteValue() == 1.0) {
            return right;
        }
        if (left instanceof RealConstant && right instanceof RealConstant) {
            double a = (Double)left.getConcreteValue();
            double b = (Double)right.getConcreteValue();
            return ExpressionFactory.buildNewRealConstant(a * b);
        }
        return new RealBinaryExpression(left, Operator.MUL, right, con);
    }

    public static RealValue div(RealValue left, RealValue right, double con) {
        if (left instanceof RealConstant && (Double)left.getConcreteValue() == 0.0) {
            return ExpressionFactory.buildNewRealConstant(0.0f);
        }
        return new RealBinaryExpression(left, Operator.DIV, right, con);
    }

    public static IntegerValue div(IntegerValue left, IntegerValue right, long con) {
        if (left instanceof IntegerConstant && (Long)left.getConcreteValue() == 0L) {
            return ExpressionFactory.buildNewIntegerConstant(0);
        }
        return new IntegerBinaryExpression(left, Operator.DIV, right, con);
    }

    public static RealValue rem(RealValue left, RealValue right, double con) {
        if (left instanceof RealConstant && (Double)left.getConcreteValue() == 0.0) {
            return ExpressionFactory.buildNewRealConstant(0.0f);
        }
        return new RealBinaryExpression(left, Operator.REM, right, con);
    }

    public static IntegerValue rem(IntegerValue left, IntegerValue right, long con) {
        if (left instanceof IntegerConstant && (Long)left.getConcreteValue() == 0L) {
            return ExpressionFactory.buildNewIntegerConstant(0);
        }
        return new IntegerBinaryExpression(left, Operator.REM, right, con);
    }

    public static ReferenceConstant buildNewNullExpression() {
        Type objectType = Type.getType(Object.class);
        ReferenceConstant referenceConstant = new ReferenceConstant(objectType, 0);
        referenceConstant.initializeReference(null);
        return referenceConstant;
    }
}

