/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import java.util.LinkedList;
import java.util.List;
import org.evosuite.symbolic.BranchCondition;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.vm.ConstraintNormalizer;

public final class PathConditionCollector {
    private final List<BranchCondition> branchConditions = new LinkedList<BranchCondition>();
    private final LinkedList<Constraint<?>> currentSupportingConstraints = new LinkedList();

    private static Constraint<?> normalizeConstraint(IntegerConstraint c) {
        return ConstraintNormalizer.normalize(c);
    }

    public void addSupportingConstraint(IntegerConstraint c) {
        Constraint<?> normalizedConstraint = PathConditionCollector.normalizeConstraint(c);
        this.currentSupportingConstraints.add(normalizedConstraint);
    }

    public void addBranchCondition(String className, String methName, int branchIndex, IntegerConstraint c) {
        Constraint<?> normalizedConstraint = PathConditionCollector.normalizeConstraint(c);
        LinkedList branch_supporting_constraints = new LinkedList(this.currentSupportingConstraints);
        BranchCondition new_branch = new BranchCondition(className, methName, branchIndex, normalizedConstraint, branch_supporting_constraints);
        this.branchConditions.add(new_branch);
        this.currentSupportingConstraints.clear();
    }

    public List<BranchCondition> getPathCondition() {
        return new LinkedList<BranchCondition>(this.branchConditions);
    }
}

