/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcarver.extraction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.TimeController;
import org.evosuite.instrumentation.BytecodeInstrumentation;
import org.evosuite.setup.TestUsageChecker;
import org.evosuite.testcarver.capture.CaptureLog;
import org.evosuite.testcarver.capture.Capturer;
import org.evosuite.testcarver.codegen.CaptureLogAnalyzer;
import org.evosuite.testcarver.codegen.ICodeGenerator;
import org.evosuite.testcarver.testcase.CarvedTestCase;
import org.evosuite.testcarver.testcase.EvoTestCaseCodeGenerator;
import org.evosuite.testcase.TestCase;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.generic.GenericTypeInference;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarvingRunListener
extends RunListener {
    private final Map<Class<?>, List<TestCase>> carvedTests = new LinkedHashMap();
    private static final Logger logger = LoggerFactory.getLogger(CarvingRunListener.class);

    public Map<Class<?>, List<TestCase>> getTestCases() {
        return this.carvedTests;
    }

    @Override
    public void testStarted(Description description) throws Exception {
        if (TimeController.getInstance().isThereStillTimeInThisPhase()) {
            logger.info("Not yet reached maximum time to carve unit tests - executing test with carver");
            Capturer.startCapture();
        } else {
            logger.info("Reached maximum time to carve unit tests - executing test without carver");
        }
    }

    @Override
    public void testFinished(Description description) throws Exception {
        CaptureLog log = Capturer.stopCapture();
        if (TimeController.getInstance().isThereStillTimeInThisPhase()) {
            LoggingUtils.getEvoLogger().info(" - Carving test {}.{}", (Object)description.getClassName(), (Object)description.getMethodName());
            this.processLog(description, log);
        }
        Capturer.clear();
    }

    private List<Class<?>> getObservedClasses(CaptureLog log) {
        ArrayList targetClasses = new ArrayList();
        Class<?> targetClass = Properties.getTargetClassAndDontInitialise();
        targetClasses.add(targetClass);
        String prop = Properties.SELECTED_JUNIT;
        if (prop == null || prop.trim().isEmpty()) {
            throw new IllegalStateException("Trying to use a test carver factory, but empty Properties.SELECTED_JUNIT");
        }
        String[] paths = prop.split(":");
        HashSet<String> junitTestNames = new HashSet<String>();
        for (String s : paths) {
            junitTestNames.add(s.trim());
        }
        if (Properties.CARVE_OBJECT_POOL) {
            LinkedHashSet<String> uniqueClasses = new LinkedHashSet<String>(log.getObservedClasses());
            for (String className : uniqueClasses) {
                if (junitTestNames.contains(className)) {
                    logger.info("Skipping JUnit test class: " + className);
                    continue;
                }
                if (BytecodeInstrumentation.checkIfCanInstrument(className)) {
                    logger.info("Instrumentable: " + className);
                    try {
                        Class<?> clazz = Class.forName(className, true, TestGenerationContext.getInstance().getClassLoaderForSUT());
                        if (TestUsageChecker.canUse(clazz) && !clazz.isArray()) {
                            if (targetClasses.contains(clazz)) continue;
                            targetClasses.add(clazz);
                            continue;
                        }
                        logger.info("Cannot access" + className);
                    }
                    catch (ClassNotFoundException e) {
                        logger.info("Error loading class " + className + ": " + e);
                    }
                    continue;
                }
                logger.info("Not Instrumentable: " + className);
            }
        }
        return targetClasses;
    }

    private void processLog(Description description, CaptureLog log) {
        CaptureLogAnalyzer analyzer = new CaptureLogAnalyzer();
        EvoTestCaseCodeGenerator codeGen = new EvoTestCaseCodeGenerator();
        logger.debug("Current log: " + log);
        List<Class<?>> observedClasses = this.getObservedClasses(log);
        for (Class<?> targetClass : observedClasses) {
            logger.debug("Current observed class: {}", (Object)targetClass.getName());
            Class[] targetClasses = new Class[]{targetClass};
            if (!this.carvedTests.containsKey(targetClass)) {
                this.carvedTests.put(targetClass, new ArrayList());
            }
            analyzer.analyze(log, (ICodeGenerator)codeGen, targetClasses);
            CarvedTestCase test = (CarvedTestCase)codeGen.getCode();
            if (test == null) {
                logger.info("Failed to carve test for " + Arrays.asList(targetClasses));
                codeGen.clear();
                continue;
            }
            test.setName(description.getMethodName());
            logger.info("Carved test of length " + test.size());
            try {
                test.changeClassLoader(TestGenerationContext.getInstance().getClassLoaderForSUT());
                GenericTypeInference inference = new GenericTypeInference();
                inference.inferTypes(test);
                this.carvedTests.get(targetClass).add(test);
            }
            catch (Throwable t) {
                logger.info("Exception during carving: " + t);
                for (StackTraceElement elem : t.getStackTrace()) {
                    logger.info(elem.toString());
                }
                logger.info(test.toCode());
            }
            codeGen.clear();
        }
    }
}

