/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.bloatcontrol.BloatControlFunction;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.testcase.ExecutableChromosome;

public class RelativeTestLengthBloatControl
implements BloatControlFunction,
SearchListener {
    private static final long serialVersionUID = -459141492060919204L;
    protected int current_max = 0;
    protected double best_fitness = Double.MAX_VALUE;

    @Override
    public boolean isTooLong(Chromosome chromosome) {
        if (chromosome.getFitness() < this.best_fitness) {
            return false;
        }
        if (this.current_max > 0) {
            return ((ExecutableChromosome)chromosome).size() > Properties.BLOAT_FACTOR * this.current_max;
        }
        return false;
    }

    @Override
    public void fitnessEvaluation(Chromosome result) {
    }

    @Override
    public void iteration(GeneticAlgorithm<?> algorithm) {
        this.current_max = ((ExecutableChromosome)algorithm.getBestIndividual()).size();
        this.best_fitness = ((Chromosome)algorithm.getBestIndividual()).getFitness();
    }

    @Override
    public void searchFinished(GeneticAlgorithm<?> algorithm) {
    }

    @Override
    public void searchStarted(GeneticAlgorithm<?> algorithm) {
    }

    @Override
    public void modification(Chromosome individual) {
    }
}

