/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.mutation;

import java.util.LinkedHashSet;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.setup.TestCluster;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.mutation.InsertionStrategy;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.variable.NullReference;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyInsertion
implements InsertionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(LegacyInsertion.class);

    private VariableReference selectVariableForCall(TestCase test, int position) {
        VariableReference var;
        if (test.isEmpty() || position == 0) {
            return null;
        }
        double sum = 0.0;
        for (int i = 0; i < position; ++i) {
            sum += 1.0 / ((double)test.getStatement(i).getReturnValue().getDistance() + 1.0);
            if (!logger.isDebugEnabled()) continue;
            logger.debug(test.getStatement(i).getCode() + ": Distance = " + test.getStatement(i).getReturnValue().getDistance());
        }
        double rnd = Randomness.nextDouble() * sum;
        for (int i = 0; i < position; ++i) {
            double dist = 1.0 / ((double)test.getStatement(i).getReturnValue().getDistance() + 1.0);
            if (!(!(dist >= rnd) || test.getStatement(i).getReturnValue() instanceof NullReference || test.getStatement(i).getReturnValue().isPrimitive() || test.getStatement(i).getReturnValue().isVoid() || test.getStatement(i) instanceof PrimitiveStatement)) {
                return test.getStatement(i).getReturnValue();
            }
            rnd -= dist;
        }
        if (position > 0) {
            position = Randomness.nextInt(position);
        }
        if (!((var = test.getStatement(position).getReturnValue()) instanceof NullReference || var.isVoid() || test.getStatement(position) instanceof PrimitiveStatement || var.isPrimitive())) {
            return var;
        }
        return null;
    }

    private VariableReference selectRandomVariableForCall(TestCase test, int position) {
        if (test.isEmpty() || position == 0) {
            return null;
        }
        List<VariableReference> allVariables = test.getObjects(position);
        LinkedHashSet<VariableReference> candidateVariables = new LinkedHashSet<VariableReference>();
        for (VariableReference var : allVariables) {
            if (var instanceof NullReference || var.isVoid() || test.getStatement(var.getStPosition()) instanceof PrimitiveStatement || var.isPrimitive()) continue;
            candidateVariables.add(var);
        }
        if (candidateVariables.isEmpty()) {
            return null;
        }
        VariableReference choice = (VariableReference)Randomness.choice(candidateVariables);
        return choice;
    }

    public boolean insertRandomCallOnObject(TestCase test, int position) {
        VariableReference var = this.selectVariableForCall(test, position);
        boolean success = false;
        if (var != null) {
            logger.debug("Inserting call at position " + position + ", chosen var: " + var.getName() + ", distance: " + var.getDistance() + ", class: " + var.getClassName());
            success = TestFactory.getInstance().insertRandomCallOnObjectAt(test, var, position);
        }
        if (!success && TestCluster.getInstance().getNumTestCalls() > 0) {
            logger.debug("Adding new call on UUT because var was null");
            success = TestFactory.getInstance().insertRandomCall(test, position);
        }
        return success;
    }

    @Override
    public int insertStatement(TestCase test, int lastPosition) {
        int oldSize = test.size();
        double r = Randomness.nextDouble();
        int max = lastPosition;
        if (max == test.size()) {
            ++max;
        }
        if (max <= 0) {
            max = 1;
        }
        int position = Randomness.nextInt(max);
        if (logger.isDebugEnabled()) {
            logger.debug(test.toCode());
        }
        boolean success = false;
        if (r <= Properties.INSERTION_UUT && TestCluster.getInstance().getNumTestCalls() > 0) {
            logger.debug("Adding new call on UUT");
            success = TestFactory.getInstance().insertRandomCall(test, position);
            if (test.size() - oldSize > 1) {
                position += test.size() - oldSize - 1;
            }
        } else {
            logger.debug("Adding new call on existing object");
            success = this.insertRandomCallOnObject(test, position);
            if (test.size() - oldSize > 1) {
                position += test.size() - oldSize - 1;
            }
        }
        if (success) {
            return position;
        }
        return -1;
    }
}

