/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.generic.GenericClass;

public class EnumPrimitiveStatement<T extends Enum<T>>
extends PrimitiveStatement<T> {
    private static final long serialVersionUID = -7027695648061887082L;
    private transient T[] constants;
    private transient Class<T> enumClass;

    public EnumPrimitiveStatement(TestCase tc, Class<T> clazz) {
        super(tc, clazz, null);
        this.enumClass = clazz;
        boolean tracerEnabled = ExecutionTracer.isEnabled();
        if (tracerEnabled) {
            ExecutionTracer.disable();
        }
        try {
            if (((Enum[])clazz.getEnumConstants()).length > 0) {
                this.value = ((Enum[])clazz.getEnumConstants())[0];
                this.constants = (Enum[])clazz.getEnumConstants();
            } else {
                this.constants = new Enum[0];
            }
        }
        catch (Throwable t) {
            this.constants = new Enum[0];
        }
        if (tracerEnabled) {
            ExecutionTracer.enable();
        }
    }

    public EnumPrimitiveStatement(TestCase tc, T value) {
        super(tc, value.getClass(), value);
        boolean tracerEnabled = ExecutionTracer.isEnabled();
        if (tracerEnabled) {
            ExecutionTracer.disable();
        }
        this.enumClass = EnumPrimitiveStatement.retrieveEnumClass(value.getClass());
        this.constants = (Enum[])EnumPrimitiveStatement.retrieveEnumClass(value.getClass()).getEnumConstants();
        if (tracerEnabled) {
            ExecutionTracer.enable();
        }
    }

    private static Class<?> retrieveEnumClass(Class<?> clazz) {
        if (clazz.isEnum()) {
            return clazz;
        }
        if (clazz.getEnclosingClass() != null && clazz.getEnclosingClass().isEnum()) {
            return clazz.getEnclosingClass();
        }
        if (clazz.getDeclaringClass() != null && clazz.getDeclaringClass().isEnum()) {
            return clazz.getDeclaringClass();
        }
        throw new RuntimeException("Cannot find enum class: " + clazz);
    }

    public Class<T> getEnumClass() {
        return this.enumClass;
    }

    public List<T> getEnumValues() {
        return Arrays.asList(this.constants);
    }

    @Override
    public void delta() {
        if (this.constants.length <= 1) {
            return;
        }
        int pos = 0;
        for (pos = 0; pos < this.constants.length && !((Enum)this.constants[pos]).equals(this.value); ++pos) {
        }
        boolean delta = Randomness.nextBoolean();
        pos = delta ? ++pos : --pos;
        if (pos >= this.constants.length) {
            pos = 0;
        } else if (pos < 0) {
            pos = this.constants.length - 1;
        }
        this.value = this.constants[pos];
    }

    @Override
    public boolean hasMoreThanOneValue() {
        return this.constants.length > 1;
    }

    @Override
    public void zero() {
        if (this.constants.length == 0) {
            return;
        }
        this.value = this.constants[0];
    }

    @Override
    public void randomize() {
        if (this.constants.length > 1) {
            int pos = Randomness.nextInt(this.constants.length);
            this.value = this.constants[pos];
        }
    }

    @Override
    public void changeClassLoader(ClassLoader loader) {
        try {
            int pos = 0;
            for (pos = 0; pos < this.constants.length && !((Enum)this.constants[pos]).equals(this.value); ++pos) {
            }
            this.enumClass = loader.loadClass(this.enumClass.getName());
            this.constants = (Enum[])this.enumClass.getEnumConstants();
            if (this.constants == null) {
                this.constants = (Enum[])this.enumClass.getEnumConstants();
            }
            if (this.constants.length > pos) {
                this.value = this.constants[pos];
            }
        }
        catch (ClassNotFoundException e) {
            logger.warn("Class not found - keeping old class loader ", e);
        }
        catch (SecurityException e) {
            logger.warn("Class not found - keeping old class loader ", e);
        }
        super.changeClassLoader(loader);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        GenericClass currentClass = new GenericClass(this.enumClass);
        oos.writeObject(currentClass);
        int pos = 0;
        for (pos = 0; pos < this.constants.length && !((Enum)this.constants[pos]).equals(this.value); ++pos) {
        }
        oos.writeInt(pos);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        GenericClass enumGenericClass = (GenericClass)ois.readObject();
        int pos = ois.readInt();
        this.enumClass = enumGenericClass.getRawClass();
        try {
            if (((Enum[])this.enumClass.getEnumConstants()).length > 0) {
                this.value = ((Enum[])this.enumClass.getEnumConstants())[0];
                this.constants = (Enum[])this.enumClass.getEnumConstants();
                if (this.constants.length > 0) {
                    this.value = this.constants[pos];
                }
            } else {
                this.constants = new Enum[0];
            }
        }
        catch (Throwable t) {
            this.constants = new Enum[0];
        }
    }
}

