/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements;

import java.io.PrintStream;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.AbstractStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testcase.variable.VariableReferenceImpl;
import org.evosuite.utils.generic.GenericAccessibleObject;

public class PrimitiveExpression
extends AbstractStatement {
    private static final long serialVersionUID = 1L;
    private VariableReference leftOperand;
    private final Operator operator;
    private VariableReference rightOperand;

    public PrimitiveExpression(TestCase testCase, VariableReference reference, VariableReference leftOperand, Operator operator, VariableReference rightOperand) {
        super(testCase, reference);
        this.leftOperand = leftOperand;
        this.operator = operator;
        this.rightOperand = rightOperand;
    }

    @Override
    public Statement copy(TestCase newTestCase, int offset) {
        VariableReferenceImpl newRetVal = new VariableReferenceImpl(newTestCase, this.retval.getType());
        VariableReference newLeftOperand = newTestCase.getStatement(this.leftOperand.getStPosition()).getReturnValue();
        VariableReference newRightOperand = newTestCase.getStatement(this.rightOperand.getStPosition()).getReturnValue();
        return new PrimitiveExpression(newTestCase, newRetVal, newLeftOperand, this.operator, newRightOperand);
    }

    @Override
    public Throwable execute(Scope scope, PrintStream out) throws IllegalArgumentException {
        try {
            Object o1 = this.leftOperand.getObject(scope);
            Object o2 = this.rightOperand.getObject(scope);
            switch (this.operator) {
                case EQUALS: {
                    if (Objects.equals(o1, o2)) {
                        scope.setObject(this.retval, true);
                        break;
                    }
                    scope.setObject(this.retval, false);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Method execute not implemented!");
                }
            }
        }
        catch (CodeUnderTestException e) {
            return e;
        }
        return null;
    }

    @Override
    public GenericAccessibleObject<?> getAccessibleObject() {
        throw new UnsupportedOperationException("Method getAccessibleObject not implemented!");
    }

    @Override
    public String getCode() {
        String code = ((Class)this.retval.getType()).getSimpleName() + " " + this.retval.getName() + " = " + this.leftOperand.getName() + " " + this.operator.toCode() + " " + this.rightOperand.getName() + ";";
        return code;
    }

    public VariableReference getLeftOperand() {
        return this.leftOperand;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public VariableReference getRightOperand() {
        return this.rightOperand;
    }

    @Override
    public List<VariableReference> getUniqueVariableReferences() {
        throw new UnsupportedOperationException("Method getUniqueVariableReferences not implemented!");
    }

    @Override
    public Set<VariableReference> getVariableReferences() {
        LinkedHashSet<VariableReference> result = new LinkedHashSet<VariableReference>();
        result.add(this.retval);
        result.add(this.leftOperand);
        result.add(this.rightOperand);
        result.addAll(this.getAssertionReferences());
        return result;
    }

    @Override
    public boolean isAssignmentStatement() {
        return false;
    }

    @Override
    public void replace(VariableReference oldVar, VariableReference newVar) {
        if (this.leftOperand.equals(oldVar)) {
            this.leftOperand = newVar;
        }
        if (this.rightOperand.equals(oldVar)) {
            this.rightOperand = newVar;
        }
    }

    @Override
    public boolean same(Statement s) {
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (this.getClass() != s.getClass()) {
            return false;
        }
        PrimitiveExpression ps = (PrimitiveExpression)s;
        return this.operator.equals((Object)ps.operator) && this.leftOperand.same(ps.leftOperand) && this.rightOperand.same(ps.rightOperand);
    }

    public String toString() {
        return this.getCode();
    }

    public static enum Operator {
        TIMES("*"),
        DIVIDE("/"),
        REMAINDER("%"),
        PLUS("+"),
        MINUS("-"),
        LEFT_SHIFT("<<"),
        RIGHT_SHIFT_SIGNED(">>"),
        RIGHT_SHIFT_UNSIGNED(">>>"),
        LESS("<"),
        GREATER(">"),
        LESS_EQUALS("<="),
        GREATER_EQUALS(">="),
        EQUALS("=="),
        NOT_EQUALS("!="),
        XOR("^"),
        AND("&"),
        OR("|"),
        CONDITIONAL_AND("&&"),
        CONDITIONAL_OR("||");

        private final String code;

        public static Operator toOperator(String code) {
            for (Operator operator : Operator.values()) {
                if (!operator.code.equals(code)) continue;
                return operator;
            }
            throw new RuntimeException("No operator for " + code);
        }

        private Operator(String code) {
            this.code = code;
        }

        public String toCode() {
            return this.code;
        }
    }
}

