/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements;

import com.googlecode.gentyref.GenericTypeReflector;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.AbstractStatement;
import org.evosuite.testcase.statements.ClassPrimitiveStatement;
import org.evosuite.testcase.statements.EnumPrimitiveStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.StringPrimitiveStatement;
import org.evosuite.testcase.statements.environment.EnvironmentStatements;
import org.evosuite.testcase.statements.numeric.BooleanPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.BytePrimitiveStatement;
import org.evosuite.testcase.statements.numeric.CharPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.DoublePrimitiveStatement;
import org.evosuite.testcase.statements.numeric.FloatPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.IntPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.LongPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.ShortPrimitiveStatement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testcase.variable.VariableReferenceImpl;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.generic.GenericAccessibleObject;
import org.evosuite.utils.generic.GenericClass;

public abstract class PrimitiveStatement<T>
extends AbstractStatement {
    private static final long serialVersionUID = -7721106626421922833L;
    protected transient T value;

    public PrimitiveStatement(TestCase tc, VariableReference varRef, T value) {
        super(tc, varRef);
        this.value = value;
    }

    public PrimitiveStatement(TestCase tc, Type type, T value) {
        super(tc, new VariableReferenceImpl(tc, type));
        this.value = value;
    }

    public PrimitiveStatement(TestCase tc, GenericClass clazz, T value) {
        super(tc, new VariableReferenceImpl(tc, clazz));
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T val) {
        this.value = val;
    }

    public boolean hasMoreThanOneValue() {
        return true;
    }

    public static PrimitiveStatement<?> getPrimitiveStatement(TestCase tc, Class<?> clazz) {
        return PrimitiveStatement.getPrimitiveStatement(tc, new GenericClass(clazz));
    }

    public static PrimitiveStatement<?> getPrimitiveStatement(TestCase tc, GenericClass genericClass) {
        PrimitiveStatement statement;
        Class<?> clazz = genericClass.getRawClass();
        if (clazz == Boolean.TYPE) {
            statement = new BooleanPrimitiveStatement(tc);
        } else if (clazz == Integer.TYPE) {
            statement = new IntPrimitiveStatement(tc);
        } else if (clazz == Character.TYPE) {
            statement = new CharPrimitiveStatement(tc);
        } else if (clazz == Long.TYPE) {
            statement = new LongPrimitiveStatement(tc);
        } else if (clazz.equals(Double.TYPE)) {
            statement = new DoublePrimitiveStatement(tc);
        } else if (clazz == Float.TYPE) {
            statement = new FloatPrimitiveStatement(tc);
        } else if (clazz == Short.TYPE) {
            statement = new ShortPrimitiveStatement(tc);
        } else if (clazz == Byte.TYPE) {
            statement = new BytePrimitiveStatement(tc);
        } else if (clazz.equals(String.class)) {
            statement = new StringPrimitiveStatement(tc);
        } else if (GenericTypeReflector.erase(clazz).isEnum()) {
            statement = new EnumPrimitiveStatement(tc, GenericTypeReflector.erase(clazz));
        } else if (EnvironmentStatements.isEnvironmentData(clazz)) {
            statement = EnvironmentStatements.getStatement(clazz, tc);
        } else if (clazz == Class.class) {
            List<Type> types = genericClass.getParameterTypes();
            Type typeParameter = null;
            if (!types.isEmpty()) {
                typeParameter = types.get(0);
                logger.debug("Creating class primitive with value " + typeParameter);
                statement = typeParameter instanceof WildcardType ? new ClassPrimitiveStatement(tc, GenericTypeReflector.erase(((WildcardType)typeParameter).getUpperBounds()[0])) : new ClassPrimitiveStatement(tc, GenericTypeReflector.erase(typeParameter));
            } else {
                logger.debug("Creating class primitive with random value / " + genericClass);
                statement = new ClassPrimitiveStatement(tc);
            }
        } else {
            throw new RuntimeException("Getting unknown type: " + clazz + " / " + clazz.getClass());
        }
        return statement;
    }

    public static PrimitiveStatement<?> getRandomStatement(TestCase tc, GenericClass clazz, int position) {
        PrimitiveStatement<?> statement = PrimitiveStatement.getPrimitiveStatement(tc, clazz);
        statement.randomize();
        return statement;
    }

    @Override
    public Statement copy(TestCase newTestCase, int offset) {
        PrimitiveStatement<?> clone = PrimitiveStatement.getPrimitiveStatement(newTestCase, this.retval.getGenericClass());
        clone.setValue(this.value);
        return clone;
    }

    @Override
    public Throwable execute(Scope scope, PrintStream out) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException {
        CodeUnderTestException exceptionThrown = null;
        try {
            this.retval.setObject(scope, this.value);
        }
        catch (CodeUnderTestException e) {
            exceptionThrown = e;
        }
        return exceptionThrown;
    }

    @Override
    public Set<VariableReference> getVariableReferences() {
        LinkedHashSet<VariableReference> references = new LinkedHashSet<VariableReference>();
        references.add(this.retval);
        return references;
    }

    @Override
    public void replace(VariableReference var1, VariableReference var2) {
        if (this.retval.equals(var1)) {
            this.retval = var2;
        }
    }

    @Override
    public boolean equals(Object s) {
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (this.getClass() != s.getClass()) {
            return false;
        }
        PrimitiveStatement ps = (PrimitiveStatement)s;
        return this.retval.equals(ps.retval) && this.value.equals(ps.value);
    }

    @Override
    public int hashCode() {
        int prime = 21;
        int result = 1;
        result = 21 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public abstract void delta();

    public abstract void zero();

    @Override
    public List<VariableReference> getUniqueVariableReferences() {
        return new ArrayList<VariableReference>(this.getVariableReferences());
    }

    @Override
    public boolean same(Statement s) {
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (this.getClass() != s.getClass()) {
            return false;
        }
        PrimitiveStatement ps = (PrimitiveStatement)s;
        boolean sameValue = false;
        sameValue = this.value == null ? ps.value == null : this.value.equals(ps.value);
        assert (this.retval != null && ps.retval != null);
        return sameValue && this.retval.same(ps.retval);
    }

    public String toString() {
        return this.getCode();
    }

    private void mutateTransformedBoolean(TestCase test) {
        if (Randomness.nextDouble() > Properties.RANDOM_PERTURBATION) {
            boolean done = false;
            for (Statement s : test) {
                Method m;
                org.evosuite.shaded.org.objectweb.asm.Type[] types;
                MethodStatement ms;
                List<VariableReference> parameters;
                int index;
                if (!(s instanceof MethodStatement) || (index = (parameters = (ms = (MethodStatement)s).getParameterReferences()).indexOf(this.retval)) < 0 || !(types = org.evosuite.shaded.org.objectweb.asm.Type.getArgumentTypes(m = ms.getMethod().getMethod()))[index].equals(org.evosuite.shaded.org.objectweb.asm.Type.BOOLEAN_TYPE)) continue;
                logger.warn("MUTATING");
                ((IntPrimitiveStatement)this).negate();
                done = true;
                break;
            }
            if (!done) {
                this.randomize();
            }
        } else {
            this.randomize();
        }
    }

    @Override
    public boolean mutate(TestCase test, TestFactory factory) {
        if (!this.hasMoreThanOneValue()) {
            return false;
        }
        T oldVal = this.value;
        while (this.value == oldVal && this.value != null) {
            if (Randomness.nextDouble() <= Properties.RANDOM_PERTURBATION) {
                if (Properties.TT && this.getClass().equals(IntPrimitiveStatement.class)) {
                    if (Randomness.nextDouble() <= Properties.RANDOM_PERTURBATION) {
                        ((IntPrimitiveStatement)this).negate();
                        continue;
                    }
                    this.randomize();
                    continue;
                }
                this.randomize();
                continue;
            }
            this.delta();
        }
        return true;
    }

    public abstract void randomize();

    @Override
    public GenericAccessibleObject<?> getAccessibleObject() {
        return null;
    }

    @Override
    public boolean isAssignmentStatement() {
        return false;
    }

    @Override
    public void changeClassLoader(ClassLoader loader) {
        super.changeClassLoader(loader);
    }
}

