/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.evosuite.Properties;
import org.evosuite.seeding.ConstantPool;
import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.utils.Randomness;

public class StringPrimitiveStatement
extends PrimitiveStatement<String> {
    private static final long serialVersionUID = 274445526699835887L;

    public StringPrimitiveStatement(TestCase tc, String value) {
        super(tc, (Type)((Object)String.class), value);
    }

    public StringPrimitiveStatement(TestCase tc) {
        super(tc, (Type)((Object)String.class), "");
    }

    @Override
    public void zero() {
        this.value = "";
    }

    private static String removeCharAt(String s, int pos) {
        return s.substring(0, pos) + s.substring(pos + 1);
    }

    private static String replaceCharAt(String s, int pos, char c) {
        return s.substring(0, pos) + c + s.substring(pos + 1);
    }

    private static String insertCharAt(String s, int pos, char c) {
        return s.substring(0, pos) + c + s.substring(pos);
    }

    private String StringInsert(String s, int pos) {
        double ALPHA = 0.5;
        int count = 1;
        while (Randomness.nextDouble() <= Math.pow(0.5, count) && s.length() < Properties.STRING_LENGTH) {
            ++count;
            s = StringPrimitiveStatement.insertCharAt(s, pos, Randomness.nextChar());
        }
        return s;
    }

    @Override
    public void delta() {
        int i;
        String s = (String)this.value;
        if (s == null) {
            this.randomize();
            return;
        }
        double P2 = 0.3333333333333333;
        double P = 1.0 / (double)s.length();
        if (Randomness.nextDouble() < 0.3333333333333333) {
            for (i = s.length(); i > 0; --i) {
                if (!(Randomness.nextDouble() < P)) continue;
                s = StringPrimitiveStatement.removeCharAt(s, i - 1);
            }
        }
        P = 1.0 / (double)s.length();
        if (Randomness.nextDouble() < 0.3333333333333333) {
            for (i = 0; i < s.length(); ++i) {
                if (!(Randomness.nextDouble() < P)) continue;
                s = StringPrimitiveStatement.replaceCharAt(s, i, Randomness.nextChar());
            }
        }
        if (Randomness.nextDouble() < 0.3333333333333333) {
            int pos = 0;
            if (s.length() > 0) {
                pos = Randomness.nextInt(s.length());
            }
            s = this.StringInsert(s, pos);
        }
        this.value = s;
    }

    public void increment() {
        String s = (String)this.value;
        if (s == null) {
            this.randomize();
            return;
        }
        s = s.isEmpty() ? s + Randomness.nextChar() : StringPrimitiveStatement.replaceCharAt(s, Randomness.nextInt(s.length()), Randomness.nextChar());
        this.value = s;
    }

    @Override
    public void randomize() {
        if (Randomness.nextDouble() >= Properties.PRIMITIVE_POOL) {
            this.value = Randomness.nextString(Randomness.nextInt(Properties.STRING_LENGTH));
        } else {
            ConstantPool constantPool = ConstantPoolManager.getInstance().getConstantPool();
            String candidateString = constantPool.getRandomString();
            this.value = Properties.MAX_STRING > 0 && candidateString.length() < Properties.MAX_STRING ? candidateString : Randomness.nextString(Randomness.nextInt(Properties.STRING_LENGTH));
        }
    }

    @Override
    public Throwable execute(Scope scope, PrintStream out) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException {
        CodeUnderTestException exceptionThrown = null;
        try {
            if (this.value == null) {
                this.retval.setObject(scope, null);
            } else {
                if (((String)this.value).length() >= Short.MAX_VALUE) {
                    throw new CodeUnderTestException(new IllegalArgumentException("Maximum string length exceeded"));
                }
                this.retval.setObject(scope, ((String)this.value).intern());
            }
        }
        catch (CodeUnderTestException e) {
            exceptionThrown = e;
        }
        return exceptionThrown;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.value);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.value = (String)ois.readObject();
    }
}

