/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements.numeric;

import org.evosuite.Properties;
import org.evosuite.seeding.ConstantPool;
import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.numeric.NumericalPrimitiveStatement;
import org.evosuite.utils.Randomness;

public class IntPrimitiveStatement
extends NumericalPrimitiveStatement<Integer> {
    private static final long serialVersionUID = -8616399657291345433L;

    public IntPrimitiveStatement(TestCase tc, Integer value) {
        super(tc, Integer.TYPE, value);
    }

    public IntPrimitiveStatement(TestCase tc) {
        super(tc, Integer.TYPE, Integer.valueOf(0));
    }

    @Override
    public void zero() {
        this.value = 0;
    }

    @Override
    public void delta() {
        int delta = (int)Math.floor(Randomness.nextGaussian() * (double)Properties.MAX_DELTA);
        this.value = (Integer)this.value + delta;
    }

    @Override
    public void increment(long delta) {
        this.value = (Integer)this.value + (int)delta;
    }

    @Override
    public void randomize() {
        if (Randomness.nextDouble() >= Properties.PRIMITIVE_POOL) {
            this.value = (int)(Randomness.nextGaussian() * (double)Properties.MAX_INT);
        } else {
            ConstantPool constantPool = ConstantPoolManager.getInstance().getConstantPool();
            this.value = constantPool.getRandomInt();
        }
    }

    @Override
    public void increment() {
        this.increment(1L);
    }

    @Override
    public void setMid(Integer min, Integer max) {
        this.value = min + (max - min) / 2;
    }

    @Override
    public void decrement() {
        this.increment(-1L);
    }

    @Override
    public boolean isPositive() {
        return (Integer)this.value >= 0;
    }

    @Override
    public void negate() {
        this.value = -((Integer)this.value).intValue();
    }

    @Override
    public Integer getValue() {
        return (Integer)this.value;
    }
}

