/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.variable;

import java.lang.reflect.Type;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testcase.variable.VariableReferenceImpl;
import org.evosuite.utils.NumberFormatter;
import org.evosuite.utils.generic.GenericClass;

public class ConstantValue
extends VariableReferenceImpl {
    private static final long serialVersionUID = -3760942087575495415L;
    private Object value;

    public ConstantValue(TestCase testCase, GenericClass type) {
        super(testCase, type);
    }

    public ConstantValue(TestCase testCase, GenericClass type, Object value) {
        super(testCase, type);
        this.setValue(value);
    }

    public ConstantValue(TestCase testCase, Type type) {
        this(testCase, new GenericClass(type));
    }

    @Override
    public VariableReference copy(TestCase newTestCase, int offset) {
        ConstantValue ret = new ConstantValue(newTestCase, this.type);
        ret.setValue(this.value);
        return ret;
    }

    @Override
    public VariableReference clone(TestCase newTestCase) {
        Statement st = newTestCase.getStatement(this.getStPosition());
        for (VariableReference var : st.getVariableReferences()) {
            if (!this.same(var)) continue;
            return var;
        }
        throw new IllegalArgumentException("Constant value not defined in new test");
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public int getStPosition() {
        for (int i = 0; i < this.testCase.size(); ++i) {
            if (!this.testCase.getStatement(i).references(this)) continue;
            return i;
        }
        throw new AssertionError((Object)"A ConstantValue position is only defined if the VariableReference is defined by a statement");
    }

    @Override
    public String getName() {
        if (this.value == null) {
            return "null";
        }
        if (this.value instanceof Class) {
            Class cl = (Class)this.value;
            String name = cl.getSimpleName();
            return name + ".class";
        }
        return NumberFormatter.getNumberString(this.value);
    }

    @Override
    public Object getObject(Scope scope) {
        return this.value;
    }

    @Override
    public boolean same(VariableReference r) {
        if (r == null) {
            return false;
        }
        if (!this.type.equals(r.getGenericClass())) {
            return false;
        }
        if (r instanceof ConstantValue) {
            ConstantValue v = (ConstantValue)r;
            if (this.value == null ? v.getValue() == null : this.value.equals(v.getValue())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void changeClassLoader(ClassLoader loader) {
        super.changeClassLoader(loader);
        if (this.value instanceof Class) {
            GenericClass genericClass = new GenericClass((Class)this.value);
            genericClass.changeClassLoader(loader);
            this.value = genericClass.getRawClass();
        }
    }
}

