/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite.localsearch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.localsearch.LocalSearchBudget;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.shaded.org.apache.commons.lang3.NotImplementedException;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteLocalSearchObjective
implements LocalSearchObjective<TestChromosome> {
    private static final Logger logger = LoggerFactory.getLogger(TestSuiteLocalSearchObjective.class);
    private final List<TestSuiteFitnessFunction> fitnessFunctions = new ArrayList<TestSuiteFitnessFunction>();
    private final TestSuiteChromosome suite;
    private final int testIndex;
    private boolean isMaximization = false;
    private double lastFitnessSum = 0.0;
    private Map<FitnessFunction<?>, Double> lastFitness = new HashMap();
    private Map<FitnessFunction<?>, Double> lastCoverage = new HashMap();

    private TestSuiteLocalSearchObjective(List<TestSuiteFitnessFunction> fitness, TestSuiteChromosome suite, int index) {
        this.fitnessFunctions.addAll(fitness);
        this.suite = suite;
        this.testIndex = index;
        Iterator<TestSuiteFitnessFunction> iterator = fitness.iterator();
        if (iterator.hasNext()) {
            TestSuiteFitnessFunction ff = iterator.next();
            this.isMaximization = ff.isMaximizationFunction();
        }
        this.updateLastFitness();
        this.updateLastCoverage();
    }

    public static TestSuiteLocalSearchObjective buildNewTestSuiteLocalSearchObjective(List<FitnessFunction<? extends Chromosome>> fitness, TestSuiteChromosome suite, int index) {
        ArrayList<TestSuiteFitnessFunction> ffs = new ArrayList<TestSuiteFitnessFunction>();
        for (FitnessFunction<? extends Chromosome> ff : fitness) {
            TestSuiteFitnessFunction tff = (TestSuiteFitnessFunction)ff;
            ffs.add(tff);
        }
        return new TestSuiteLocalSearchObjective(ffs, suite, index);
    }

    private void updateLastFitness() {
        this.lastFitnessSum = 0.0;
        for (TestSuiteFitnessFunction fitness : this.fitnessFunctions) {
            double newFitness = fitness.getFitness(this.suite);
            this.lastFitnessSum += newFitness;
            this.lastFitness.put(fitness, newFitness);
        }
    }

    private void updateLastCoverage() {
        for (TestSuiteFitnessFunction fitness : this.fitnessFunctions) {
            this.lastCoverage.put(fitness, this.suite.getCoverage(fitness));
        }
    }

    @Override
    public boolean isDone() {
        for (TestSuiteFitnessFunction fitness : this.fitnessFunctions) {
            if (!fitness.isMaximizationFunction() && fitness.getFitness(this.suite) == 0.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasImproved(TestChromosome testCase) {
        return this.hasChanged(testCase) < 0;
    }

    @Override
    public boolean hasNotWorsened(TestChromosome testCase) {
        return this.hasChanged(testCase) < 1;
    }

    private boolean isFitnessBetter(double newFitness, double oldFitness) {
        if (this.isMaximization) {
            return newFitness > oldFitness;
        }
        return newFitness < oldFitness;
    }

    private boolean isFitnessWorse(double newFitness, double oldFitness) {
        if (this.isMaximization) {
            return newFitness < oldFitness;
        }
        return newFitness > oldFitness;
    }

    @Override
    public int hasChanged(TestChromosome testCase) {
        testCase.setChanged(true);
        this.suite.setTestChromosome(this.testIndex, testCase);
        LocalSearchBudget.getInstance().countFitnessEvaluation();
        for (TestSuiteFitnessFunction fitnessFunction : this.fitnessFunctions) {
            fitnessFunction.getFitness(this.suite);
        }
        double newFitness = this.suite.getFitness();
        if (this.isFitnessBetter(newFitness, this.lastFitnessSum)) {
            logger.info("Local search improved fitness from " + this.lastFitnessSum + " to " + newFitness);
            this.updateLastFitness();
            this.updateLastCoverage();
            return -1;
        }
        if (this.isFitnessWorse(newFitness, this.lastFitnessSum)) {
            logger.info("Local search worsened fitness from " + this.lastFitnessSum + " to " + newFitness);
            this.suite.setFitnessValues(this.lastFitness);
            this.suite.setCoverageValues(this.lastCoverage);
            return 1;
        }
        logger.info("Local search did not change fitness of " + this.lastFitnessSum);
        this.updateLastCoverage();
        return 0;
    }

    @Override
    public List<FitnessFunction<? extends Chromosome>> getFitnessFunctions() {
        throw new NotImplementedException("This should not be called");
    }

    @Override
    public void addFitnessFunction(FitnessFunction<? extends Chromosome> fitness) {
        throw new NotImplementedException("This should not be called");
    }

    @Override
    public boolean isMaximizationObjective() {
        return this.isMaximization;
    }
}

