/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.evosuite.ClientProcess;
import org.evosuite.ConsoleProgressBar;
import org.evosuite.Properties;
import org.evosuite.result.TestGenerationResult;
import org.evosuite.result.TestGenerationResultBuilder;
import org.evosuite.rmi.MasterServices;
import org.evosuite.rmi.service.ClientNodeRemote;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ExternalProcessHandler {
    protected static final Logger logger = LoggerFactory.getLogger(ExternalProcessHandler.class);
    protected ServerSocket server;
    protected Process process;
    protected String[] last_command;
    protected Thread output_printer;
    protected Thread error_printer;
    protected Thread message_handler;
    protected Socket connection;
    protected ObjectOutputStream out;
    protected ObjectInputStream in;
    protected Object final_result;
    protected static final Object WAITING_FOR_DATA = "waiting_for_data_" + System.currentTimeMillis();
    protected Thread processKillHook;
    protected Thread clientRunningOnThread;
    protected volatile CountDownLatch latch;
    protected String base_dir = System.getProperty("user.dir");
    private String hsErrFile;

    public void stopAndWaitForClientOnThread(long ms) {
        if (this.clientRunningOnThread != null && this.clientRunningOnThread.isAlive()) {
            this.clientRunningOnThread.interrupt();
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < ms && this.clientRunningOnThread != null && this.clientRunningOnThread.isAlive()) {
            try {
                this.clientRunningOnThread.join(ms - (System.currentTimeMillis() - start));
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        if (this.clientRunningOnThread != null && this.clientRunningOnThread.isAlive()) {
            throw new AssertionError((Object)("clientRunningOnThread is alive even after waiting " + ms + "ms"));
        }
    }

    public void setBaseDir(String base_dir) {
        this.base_dir = base_dir;
    }

    public boolean startProcess(String[] command) {
        if (!Properties.IS_RUNNING_A_SYSTEM_TEST) {
            logger.debug("Going to start process with command: " + Arrays.toString(command).replace(",", " "));
        }
        LinkedList<String> formatted = new LinkedList<String>();
        for (String s : command) {
            String token = s.trim();
            if (token.isEmpty()) continue;
            formatted.add(token);
        }
        this.hsErrFile = "hs_err_EvoSuite_client_p" + this.getServerPort() + "_t" + System.currentTimeMillis();
        String option = "-XX:ErrorFile=" + this.hsErrFile;
        formatted.add(1, option);
        return this.startProcess(formatted.toArray(new String[0]), null);
    }

    protected boolean didClientJVMCrash() {
        return new File(this.hsErrFile).exists();
    }

    protected String getAndDeleteHsErrFile() {
        if (!this.didClientJVMCrash()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        File file = new File(this.hsErrFile);
        file.deleteOnExit();
        try (Scanner in = new Scanner(file);){
            String row;
            while (in.hasNextLine() && (row = in.nextLine()).startsWith("#")) {
                buffer.append(row + "\n");
            }
        }
        catch (FileNotFoundException e) {
            logger.error("Error while reading " + file.getAbsolutePath() + ": " + e.getMessage());
            return null;
        }
        return buffer.toString();
    }

    public String getProcessState() {
        if (this.process == null) {
            return "null";
        }
        try {
            return "Terminated with exit status " + this.process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            return "Still running";
        }
    }

    protected boolean startProcess(String[] command, Object population_data) {
        if (this.process != null) {
            logger.warn("Already running an external process");
            return false;
        }
        this.latch = new CountDownLatch(1);
        this.final_result = WAITING_FOR_DATA;
        this.processKillHook = new Thread(){

            @Override
            public void run() {
                ExternalProcessHandler.this.killProcess();
                ExternalProcessHandler.this.closeServer();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.processKillHook);
        if (!Properties.CLIENT_ON_THREAD) {
            File dir = new File(this.base_dir);
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.directory(dir);
            builder.redirectErrorStream(false);
            try {
                this.process = builder.start();
            }
            catch (IOException e) {
                logger.error("Failed to start external process", e);
                return false;
            }
            this.startExternalProcessPrinter();
        } else {
            this.clientRunningOnThread = new Thread(){

                @Override
                public void run() {
                    ClientProcess.main(new String[0]);
                }
            };
            this.clientRunningOnThread.setName("client");
            this.clientRunningOnThread.start();
            Sandbox.addPrivilegedThread(this.clientRunningOnThread);
        }
        this.startSignalHandler();
        this.last_command = command;
        return true;
    }

    public void killProcess() {
        try {
            Runtime.getRuntime().removeShutdownHook(this.processKillHook);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.process != null) {
            try {
                this.process.getOutputStream().close();
                this.process.getInputStream().close();
                this.process.getErrorStream().close();
            }
            catch (Exception t) {
                logger.error("Failed to close process stream: " + t.toString());
            }
            this.process.destroy();
        }
        this.process = null;
        if (this.clientRunningOnThread != null && this.clientRunningOnThread.isAlive()) {
            this.clientRunningOnThread.interrupt();
        }
        this.clientRunningOnThread = null;
        if (this.output_printer != null && this.output_printer.isAlive()) {
            this.output_printer.interrupt();
        }
        this.output_printer = null;
        if (this.error_printer != null && this.error_printer.isAlive()) {
            this.error_printer.interrupt();
        }
        this.error_printer = null;
        if (this.message_handler != null && this.message_handler.isAlive()) {
            this.message_handler.interrupt();
        }
        this.message_handler = null;
    }

    public int getServerPort() {
        return MasterServices.getInstance().getRegistryPort();
    }

    public int openServer() {
        boolean started = MasterServices.getInstance().startRegistry();
        if (!started) {
            logger.error("Not possible to start RMI registry");
            return -1;
        }
        try {
            MasterServices.getInstance().registerServices();
        }
        catch (RemoteException e) {
            logger.error("Failed to start RMI services", e);
            return -1;
        }
        return MasterServices.getInstance().getRegistryPort();
    }

    public void closeServer() {
        MasterServices.getInstance().stopServices();
    }

    protected void startExternalProcessPrinter() {
        if (this.output_printer == null || !this.output_printer.isAlive()) {
            this.output_printer = new Thread(){

                @Override
                public void run() {
                    try {
                        BufferedReader proc_in = new BufferedReader(new InputStreamReader(ExternalProcessHandler.this.process.getInputStream()));
                        int data = 0;
                        while (data != -1 && !this.isInterrupted()) {
                            data = proc_in.read();
                            if (data == -1 || !Properties.PRINT_TO_SYSTEM) continue;
                            System.out.print((char)data);
                        }
                    }
                    catch (Exception e) {
                        if (MasterServices.getInstance().getMasterNode() == null) {
                            return;
                        }
                        boolean finished = true;
                        for (ClientState state : MasterServices.getInstance().getMasterNode().getCurrentState()) {
                            if (state == ClientState.DONE) continue;
                            finished = false;
                            break;
                        }
                        if (!finished) {
                            logger.error("Exception while reading output of client process. " + e.getMessage());
                        }
                        logger.debug("Exception while reading output of client process. " + e.getMessage());
                    }
                }
            };
            this.output_printer.start();
        }
        if (this.error_printer == null || !this.error_printer.isAlive()) {
            this.error_printer = new Thread(){

                @Override
                public void run() {
                    try {
                        BufferedReader proc_in = new BufferedReader(new InputStreamReader(ExternalProcessHandler.this.process.getErrorStream()));
                        int data = 0;
                        String errorLine = "";
                        while (data != -1 && !this.isInterrupted()) {
                            data = proc_in.read();
                            if (data == -1 || !Properties.PRINT_TO_SYSTEM) continue;
                            System.err.print((char)data);
                            errorLine = errorLine + (char)data;
                            if ((char)data != '\n') continue;
                            logger.error(errorLine);
                            errorLine = "";
                        }
                    }
                    catch (Exception e) {
                        if (MasterServices.getInstance().getMasterNode() == null) {
                            return;
                        }
                        boolean finished = true;
                        for (ClientState state : MasterServices.getInstance().getMasterNode().getCurrentState()) {
                            if (state == ClientState.DONE) continue;
                            finished = false;
                            break;
                        }
                        if (!finished) {
                            logger.error("Exception while reading output of client process. " + e.getMessage());
                        }
                        logger.debug("Exception while reading output of client process. " + e.getMessage());
                    }
                }
            };
            this.error_printer.start();
        }
        if (Properties.SHOW_PROGRESS && (Properties.LOG_LEVEL == null || !Properties.LOG_LEVEL.equals("info") && !Properties.LOG_LEVEL.equals("debug") && !Properties.LOG_LEVEL.equals("trace"))) {
            ConsoleProgressBar.startProgressBar();
        }
    }

    protected void startExternalProcessMessageHandler() {
        if (this.message_handler != null && this.message_handler.isAlive()) {
            return;
        }
        this.message_handler = new Thread(){

            @Override
            public void run() {
                boolean read = true;
                while (read && !this.isInterrupted()) {
                    String message = null;
                    Object data = null;
                    try {
                        message = (String)ExternalProcessHandler.this.in.readObject();
                        data = ExternalProcessHandler.this.in.readObject();
                        logger.debug("Received msg: " + message);
                        logger.debug("Received data: " + data);
                    }
                    catch (Exception e) {
                        logger.error("Class " + Properties.TARGET_CLASS + ". Error when reading message. Likely the client has crashed. Error message: " + e.getMessage());
                        message = "FINISHED_COMPUTATION";
                        data = null;
                    }
                    if (message.equals("FINISHED_COMPUTATION")) {
                        LoggingUtils.getEvoLogger().info("* Computation finished");
                        read = false;
                        ExternalProcessHandler.this.killProcess();
                        ExternalProcessHandler.this.final_result = data;
                        ExternalProcessHandler.this.latch.countDown();
                        continue;
                    }
                    if (message.equals("NEED_RESTART")) {
                        LoggingUtils.getEvoLogger().info("* Restarting client process");
                        ExternalProcessHandler.this.killProcess();
                        ExternalProcessHandler.this.startProcess(ExternalProcessHandler.this.last_command, data);
                        continue;
                    }
                    ExternalProcessHandler.this.killProcess();
                    logger.error("Class " + Properties.TARGET_CLASS + ". Error, received invalid message: ", (Object)message);
                    return;
                }
            }
        };
        this.message_handler.start();
    }

    protected void startSignalHandler() {
        Signal.handle(new Signal("INT"), new SignalHandler(){
            private boolean interrupted = false;

            @Override
            public void handle(Signal arg0) {
                if (this.interrupted) {
                    System.exit(0);
                }
                try {
                    this.interrupted = true;
                    if (ExternalProcessHandler.this.process != null) {
                        ExternalProcessHandler.this.process.waitFor();
                    }
                }
                catch (InterruptedException e) {
                    logger.warn("", e);
                }
            }
        });
    }

    public TestGenerationResult waitForResult(int timeout) {
        try {
            long start = System.currentTimeMillis();
            Set<ClientNodeRemote> clients = MasterServices.getInstance().getMasterNode().getClientsOnceAllConnected(timeout);
            if (clients == null) {
                logger.error("Could not access client process");
                return TestGenerationResultBuilder.buildErrorResult("Could not access client process");
            }
            for (ClientNodeRemote client : clients) {
                boolean finished;
                long passed = System.currentTimeMillis() - start;
                long remaining = (long)timeout - passed;
                if (remaining <= 0L) {
                    remaining = 1L;
                }
                if (finished = client.waitUntilFinished(remaining)) continue;
                logger.error("Class " + Properties.TARGET_CLASS + ". Clients have not finished yet, although a timeout occurred.\n" + MasterServices.getInstance().getMasterNode().getSummaryOfClientStatuses());
            }
        }
        catch (InterruptedException start) {
        }
        catch (RemoteException e) {
            String msg = "Class " + Properties.TARGET_CLASS + ". Lost connection with clients.\n" + MasterServices.getInstance().getMasterNode().getSummaryOfClientStatuses();
            if (this.didClientJVMCrash()) {
                String err = this.getAndDeleteHsErrFile();
                msg = msg + "The JVM of the client process crashed:\n" + err;
                logger.error(msg);
            }
            logger.error(msg, e);
        }
        this.killProcess();
        LoggingUtils.getEvoLogger().info("* Computation finished");
        return null;
    }
}

