/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils.generic;

import com.googlecode.gentyref.GenericTypeReflector;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.shaded.org.apache.commons.lang3.ClassUtils;
import org.evosuite.shaded.org.apache.commons.lang3.reflect.TypeUtils;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestVisitor;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.FieldStatement;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.NullStatement;
import org.evosuite.testcase.statements.PrimitiveExpression;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.generic.GenericClass;
import org.evosuite.utils.generic.GenericConstructor;
import org.evosuite.utils.generic.GenericMethod;
import org.evosuite.utils.generic.WildcardTypeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericTypeInference
extends TestVisitor {
    private static Logger logger = LoggerFactory.getLogger(GenericTypeInference.class);
    private final Map<VariableReference, Set<Type>> variableMap = new LinkedHashMap<VariableReference, Set<Type>>();
    private final Map<Type, Set<VariableReference>> typeMap = new LinkedHashMap<Type, Set<VariableReference>>();
    private TestCase test;

    public void inferTypes(TestCase test) {
        this.test = test;
        logger.debug("Inferring generic types");
        for (int i = test.size() - 1; i >= 0; --i) {
            Statement statement = test.getStatement(i);
            if (!(statement instanceof ConstructorStatement)) continue;
            this.determineExactType((ConstructorStatement)statement);
        }
        logger.debug("Resulting test: " + test.toCode());
    }

    private void addVariable(Statement statement) {
        VariableReference retVal = statement.getReturnValue();
        this.variableMap.put(retVal, new LinkedHashSet());
    }

    private void addTypeAssignment(Type type, VariableReference value) {
        if (!this.typeMap.containsKey(type)) {
            this.typeMap.put(type, new LinkedHashSet());
        }
        this.typeMap.get(type).add(value);
        this.variableMap.get(value).add(type);
    }

    protected void calculateExactTypes() {
        logger.info("Types to consider: " + this.typeMap.size());
        for (Type type : this.typeMap.keySet()) {
            logger.info("Current type: " + type);
            if (type instanceof ParameterizedType) {
                this.calculateExactType((ParameterizedType)type);
                continue;
            }
            if (type instanceof WildcardType) {
                this.calculateExactType((WildcardType)type);
                continue;
            }
            if (type instanceof TypeVariable) {
                this.calculateExactType((TypeVariable)type);
                continue;
            }
            if (!(type instanceof GenericArrayType)) continue;
            this.calculateExactType((GenericArrayType)type);
        }
    }

    private void calculateExactType(ParameterizedType type) {
        logger.info("Calculating exact tyep for parameterized type " + type);
        Class<?> rawClass = GenericTypeReflector.erase(type);
        Type exactType = type;
        for (VariableReference var : this.typeMap.get(type)) {
            ParameterizedType currentType = (ParameterizedType)var.getType();
            logger.info("Assigned variable of type: " + currentType);
            Type candidateType = GenericTypeReflector.getExactSuperType(currentType, rawClass);
            logger.info("Resulting type: " + candidateType);
            if (!TypeUtils.isAssignable(candidateType, exactType)) continue;
            exactType = candidateType;
        }
        logger.info("Result: " + exactType);
    }

    private void calculateExactType(WildcardType type) {
        logger.info("Calculating exact tyep for wildcard type " + type);
    }

    private void calculateExactType(GenericArrayType type) {
        logger.info("Calculating exact tyep for generic array type " + type);
    }

    private void calculateExactType(TypeVariable<?> type) {
        logger.info("Calculating exact type for typevariable " + type);
        Type[] bounds = TypeUtils.getImplicitBounds(type);
        Type exactType = bounds[0];
        for (VariableReference var : this.typeMap.get(type)) {
            Type candidateType = var.getType();
            logger.info("Candidate type: " + candidateType);
            if (!TypeUtils.isAssignable(candidateType, exactType)) continue;
            exactType = candidateType;
        }
        logger.info("Result: " + exactType);
    }

    private void addToMap(TypeVariable<?> type, Type actualType, Map<TypeVariable<?>, Type> typeMap) {
        typeMap.put(type, actualType);
    }

    private void addToMap(ParameterizedType type, Type actualType, Map<TypeVariable<?>, Type> typeMap) {
        Type[] parameterTypes = type.getActualTypeArguments();
        TypeVariable<Class<T>>[] variables = ((Class)type.getRawType()).getTypeParameters();
        for (int i = 0; i < parameterTypes.length; ++i) {
            typeMap.put(variables[i], parameterTypes[i]);
        }
    }

    private void addToMap(Type type, Type actualType, Map<TypeVariable<?>, Type> typeMap) {
        if (type instanceof ParameterizedType) {
            this.addToMap((ParameterizedType)type, actualType, typeMap);
        } else if (type instanceof TypeVariable) {
            this.addToMap((TypeVariable)type, actualType, typeMap);
        } else if (type instanceof GenericArrayType) {
            logger.info("Is generic array with component type " + ((GenericArrayType)type).getGenericComponentType());
            logger.info("Actual type " + actualType + ", " + actualType.getClass());
            if (actualType instanceof GenericArrayType) {
                this.addToMap(((GenericArrayType)type).getGenericComponentType(), ((GenericArrayType)actualType).getGenericComponentType(), typeMap);
            } else if (actualType instanceof Class && ((Class)actualType).isArray()) {
                this.addToMap(((GenericArrayType)type).getGenericComponentType(), ((Class)actualType).getComponentType(), typeMap);
            }
        } else {
            logger.info("Is unexpected type: " + type + ", " + type.getClass());
        }
    }

    private Map<TypeVariable<?>, Type> getParameterType(Type parameterType, Type valueType) {
        LinkedHashMap typeMap = new LinkedHashMap();
        this.addToMap(parameterType, valueType, typeMap);
        return typeMap;
    }

    private void determineVariableFromParameter(VariableReference parameter, Type parameterType, Map<TypeVariable<?>, Type> typeMap) {
        Map<TypeVariable<?>, Type> parameterTypeMap = this.getParameterType(parameterType, parameter.getType());
        logger.info("Resulting map: " + parameterTypeMap);
        for (TypeVariable<?> typeVar : parameterTypeMap.keySet()) {
            Type actualType = parameterTypeMap.get(typeVar);
            if (typeMap.containsKey(typeVar)) {
                logger.info("Variable is in map: " + typeVar);
                Type currentType = typeMap.get(typeVar);
                if (currentType == null || TypeUtils.isAssignable(actualType, currentType)) {
                    typeMap.put(typeVar, actualType);
                    continue;
                }
                logger.info("Not assignable: " + typeVar + " with bounds " + Arrays.asList(typeVar.getBounds()) + " and current type " + currentType + " from " + actualType);
                logger.info("" + GenericTypeReflector.isSuperType(currentType, actualType));
                logger.info("" + TypeUtils.isAssignable(actualType, typeVar));
                continue;
            }
            logger.debug("Variable is not in map: " + typeVar);
            typeMap.put(typeVar, actualType);
        }
    }

    private void determineVariablesFromParameters(List<VariableReference> parameters, Type[] parameterTypes, Map<TypeVariable<?>, Type> parameterTypeMap) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            logger.debug("Current parameter: " + parameterTypes[i]);
            Type parameterType = parameterTypes[i];
            VariableReference parameter = parameters.get(i);
            this.determineVariableFromParameter(parameter, parameterType, parameterTypeMap);
        }
    }

    private void determineExactType(ConstructorStatement constructorStatement) {
        GenericConstructor constructor = constructorStatement.getConstructor();
        logger.debug("Inferring types for: " + constructorStatement.getCode() + " at position " + constructorStatement.getPosition());
        Map<TypeVariable<?>, Type> typeMap = constructor.getOwnerClass().getTypeVariableMap();
        if (constructor.getOwnerClass().hasTypeVariables()) {
            logger.info("Has types: " + constructor.getOwnerClass());
            logger.info("Initial type map: " + typeMap);
            for (TypeVariable<?> var : typeMap.keySet()) {
                typeMap.put(var, null);
            }
            Type[] parameterTypes = constructor.getGenericParameterTypes();
            List<VariableReference> parameterValues = constructorStatement.getParameterReferences();
            this.determineVariablesFromParameters(parameterValues, parameterTypes, typeMap);
            for (int pos = constructorStatement.getPosition() + 1; pos < this.test.size(); ++pos) {
                MethodStatement ms;
                if (!(this.test.getStatement(pos) instanceof MethodStatement) || (ms = (MethodStatement)this.test.getStatement(pos)).isStatic() || !ms.getCallee().equals(constructorStatement.getReturnValue())) continue;
                logger.info("Found relevant statement: " + ms.getCode());
                parameterTypes = ms.getMethod().getGenericParameterTypes();
                parameterValues = ms.getParameterReferences();
                this.determineVariablesFromParameters(parameterValues, parameterTypes, typeMap);
            }
            logger.info("Setting types based on map: " + typeMap);
            GenericClass owner = constructor.getOwnerClass();
            List<TypeVariable<?>> variables = owner.getTypeVariables();
            ArrayList<Type> types = new ArrayList<Type>();
            for (TypeVariable<?> var : variables) {
                Type type = typeMap.get(var);
                if (type == null) {
                    types.add(new WildcardTypeImpl(TypeUtils.getImplicitBounds(var), new Type[0]));
                    continue;
                }
                Class<?> paramClass = GenericTypeReflector.erase(type);
                if (paramClass.isPrimitive()) {
                    types.add(ClassUtils.primitiveToWrapper(paramClass));
                    continue;
                }
                types.add(typeMap.get(var));
            }
            constructorStatement.setConstructor(constructor.copyWithNewOwner(owner.getWithParameterTypes(types)));
            logger.info("New type: " + constructorStatement);
            this.updateMethodCallsOfGenericOwner(constructorStatement.getReturnValue());
        } else {
            logger.info("Type map empty");
        }
    }

    private void updateMethodCallsOfGenericOwner(VariableReference callee) {
        for (int pos = callee.getStPosition() + 1; pos < this.test.size(); ++pos) {
            MethodStatement ms;
            Statement statement = this.test.getStatement(pos);
            if (!(statement instanceof MethodStatement) || (ms = (MethodStatement)statement).isStatic() || !ms.getCallee().equals(callee)) continue;
            GenericMethod method = ms.getMethod();
            logger.info("Updating callee of statement " + statement.getCode());
            ms.setMethod(method.copyWithNewOwner(callee.getGenericClass()));
            ms.getReturnValue().setType(ms.getMethod().getReturnType());
            logger.info("Result: " + statement.getCode());
        }
    }

    @Override
    public void visitTestCase(TestCase test) {
        this.test = test;
    }

    @Override
    public void visitPrimitiveStatement(PrimitiveStatement<?> statement) {
        this.addVariable(statement);
    }

    @Override
    public void visitFieldStatement(FieldStatement statement) {
        this.addVariable(statement);
    }

    @Override
    public void visitMethodStatement(MethodStatement statement) {
        this.addVariable(statement);
        GenericMethod method = statement.getMethod();
        List<VariableReference> parameterVariables = statement.getParameterReferences();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            Type genericType = genericParameterTypes[i];
            VariableReference value = parameterVariables.get(i);
            this.addTypeAssignment(genericType, value);
        }
    }

    @Override
    public void visitConstructorStatement(ConstructorStatement statement) {
        this.addVariable(statement);
        GenericConstructor constructor = statement.getConstructor();
        List<VariableReference> parameterVariables = statement.getParameterReferences();
        Type[] genericParameterTypes = constructor.getGenericParameterTypes();
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            Type genericType = genericParameterTypes[i];
            VariableReference value = parameterVariables.get(i);
            this.addTypeAssignment(genericType, value);
        }
        this.determineExactType(statement);
    }

    @Override
    public void visitArrayStatement(ArrayStatement statement) {
        this.addVariable(statement);
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement statement) {
        this.addVariable(statement);
    }

    @Override
    public void visitNullStatement(NullStatement statement) {
        this.addVariable(statement);
    }

    @Override
    public void visitPrimitiveExpression(PrimitiveExpression primitiveExpression) {
    }

    @Override
    public void visitFunctionalMockStatement(FunctionalMockStatement functionalMockStatement) {
    }
}

