/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import java.util.UUID;

public class Random {
    private static boolean wasAccessed = false;
    private static int currentNumber = 0;

    public static int nextInt() {
        wasAccessed = true;
        return currentNumber++;
    }

    public static int nextInt(int max) {
        wasAccessed = true;
        return currentNumber % max;
    }

    public static float nextFloat() {
        wasAccessed = true;
        return (float)currentNumber++ % 10.0f / 10.0f;
    }

    public static void nextBytes(byte[] bytes) {
        wasAccessed = true;
        int i = 0;
        while (i < bytes.length) {
            int rnd = Random.nextInt();
            int n = Math.min(bytes.length - i, 4);
            while (n-- > 0) {
                bytes[i++] = (byte)rnd;
                rnd >>= 8;
            }
        }
    }

    public static double nextDouble() {
        wasAccessed = true;
        return (double)currentNumber++ % 10.0 / 10.0;
    }

    public static double nextGaussian() {
        wasAccessed = true;
        return Random.nextDouble();
    }

    public static boolean nextBoolean() {
        wasAccessed = true;
        return Random.nextInt(1) != 0;
    }

    public static long nextLong() {
        wasAccessed = true;
        return currentNumber++;
    }

    public static void setNextRandom(int number) {
        currentNumber = Math.abs(number);
    }

    public static void reset() {
        currentNumber = 0;
        wasAccessed = false;
    }

    public static boolean wasAccessed() {
        return wasAccessed;
    }

    public static UUID randomUUID() {
        wasAccessed = true;
        byte[] randomBytes = new byte[16];
        Random.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        UUID newUUID = Random.buildNewUUID(randomBytes);
        return newUUID;
    }

    private static UUID buildNewUUID(byte[] data) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        assert (data.length == 16) : "data must be 16 bytes in length";
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        UUID newUUID = new UUID(msb, lsb);
        return newUUID;
    }

    public static int getCurrentNumber() {
        return currentNumber;
    }
}

