/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.agent;

import java.lang.instrument.Instrumentation;
import org.evosuite.runtime.LoopCounter;
import org.evosuite.runtime.agent.AgentLoader;
import org.evosuite.runtime.agent.TransformerForTests;
import org.evosuite.runtime.mock.MockFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentingAgent {
    private static final Logger logger = LoggerFactory.getLogger(InstrumentingAgent.class);
    private static volatile TransformerForTests transformer;
    private static Instrumentation instrumentation;

    public static void premain(String args, Instrumentation inst) throws Exception {
        logger.info("Executing premain of JavaAgent");
        InstrumentingAgent.checkTransformerState();
        inst.addTransformer(transformer, true);
        instrumentation = inst;
    }

    public static void agentmain(String args, Instrumentation inst) throws Exception {
        logger.info("Executing agentmain of JavaAgent");
        InstrumentingAgent.checkTransformerState();
        inst.addTransformer(transformer, true);
        instrumentation = inst;
    }

    private static void checkTransformerState() throws IllegalStateException {
        if (transformer == null) {
            String msg = "TransformerForTests was not properly initialized";
            logger.error(msg);
            throw new IllegalStateException(msg);
        }
    }

    public static void initialize() {
        MockFramework.disable();
        AgentLoader.loadAgent();
    }

    public static TransformerForTests getTransformer() throws IllegalStateException {
        InstrumentingAgent.checkTransformerState();
        return transformer;
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    public static void activate() {
        InstrumentingAgent.checkTransformerState();
        MockFramework.enable();
        transformer.activate();
        LoopCounter.getInstance().setActive(true);
    }

    public static void deactivate() {
        InstrumentingAgent.checkTransformerState();
        MockFramework.disable();
        transformer.deactivate();
        LoopCounter.getInstance().setActive(false);
    }

    public static void setRetransformingMode(boolean on) {
        transformer.setRetransformingMode(on);
    }

    static {
        try {
            transformer = new TransformerForTests();
        }
        catch (Exception e) {
            logger.error("Failed to initialize TransformerForTests: " + e.getMessage(), (Throwable)e);
            transformer = null;
        }
    }
}

